/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.impl;

import com.mulesoft.mule.debugger.dto.FieldPath;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.dto.ScriptResultInfo;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.response.callback.DefaultDebuggerResponseCallback;
import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.ui.contribution.debugger.controller.ObjectFieldDefinitionTreeContentProvider;
import org.mule.tooling.ui.contribution.debugger.controller.ObjectTreeNodeBuilder;
import org.mule.tooling.ui.contribution.debugger.controller.ScriptEditorController;
import org.mule.tooling.ui.contribution.debugger.controller.TreeNodeLabelProvider;
import org.mule.tooling.ui.contribution.debugger.preferences.DebuggerPreferences;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.impl.MuleDebuggerView;
import org.mule.tooling.ui.contribution.debugger.view.impl.ObjectFieldDefinitionComposite;
import org.mule.tooling.ui.contribution.debugger.view.impl.ScriptEditorComposite;
import org.mule.tooling.ui.widgets.text.History;
import org.mule.tooling.ui.widgets.theme.StudioDarkTheme;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class ScriptEvaluatePopupDialog
extends PopupDialog {
    private ObjectFieldDefinitionComposite objectFieldDefComp;
    private ScriptEditorComposite scriptEditorComposite;
    private static DialogSettings settings = new DialogSettings("Workbench");
    private History scriptHistory;
    private Button evaluateLabel;
    private Button clearLabel;
    private Button addLabel;
    private boolean pin = false;
    private boolean lastPin;
    private ToolItem viewMenuButton;

    public static ScriptEvaluatePopupDialog getInstance() {
        return Singleton.instance;
    }

    private ScriptEvaluatePopupDialog(Shell parent, int shellStyle, boolean takeFocusOnOpen, boolean persistSize, boolean persistLocation, boolean showDialogMenu, boolean showPersistActions, String titleText, String infoText) {
        super(parent, shellStyle, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, infoText);
    }

    private ScriptEvaluatePopupDialog(Shell parent) {
        this(parent, 16, true, true, true, true, true, null, null);
    }

    protected List<Control> getBackgroundColorExclusions() {
        List list = super.getBackgroundColorExclusions();
        if (ThemeUtils.getCurrentTheme() instanceof StudioDarkTheme) {
            list.add(this.objectFieldDefComp.getPayloadTreeViewer().getControl());
            list.add(this.objectFieldDefComp.getValueText());
            list.addAll(this.addRecursive(this.scriptEditorComposite));
            list.add(this.addLabel);
            list.add(this.clearLabel);
            list.add(this.evaluateLabel);
        }
        return list;
    }

    private List<Control> addRecursive(Composite composite) {
        ArrayList<Control> list = new ArrayList<Control>();
        list.add((Control)composite);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            list.addAll(this.addRecursive((Composite)child));
            ++n2;
        }
        return list;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        Listener[] listenerArray = shell.getListeners(27);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            shell.removeListener(27, listener);
            ++n2;
        }
        shell.addListener(27, event -> {
            if (!this.pin) {
                this.close();
            }
        });
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        PinAction pin = new PinAction();
        dialogMenu.insertBefore("SystemMenuEnd", (IAction)pin);
    }

    protected Control createDialogArea(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x800100);
        this.viewMenuButton = new ToolItem(toolBar, 4, 0);
        this.viewMenuButton.setText("Script History");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)toolBar);
        this.createInputExpressionArea(parent);
        this.objectFieldDefComp = this.createObjectFieldDefComp(parent);
        ThemeUtils.setCssId((Object)this.objectFieldDefComp.getValueText(), (String)"valueText");
        ThemeUtils.setCssId((Object)this.objectFieldDefComp.getPayloadTreeViewer().getControl(), (String)"payloadTreeViewer");
        return this.objectFieldDefComp;
    }

    protected Control createTitleControl(Composite parent) {
        Label titleLabel = new Label(parent, 0);
        titleLabel.setText("Evaluate DataWeave expression");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)titleLabel);
        return titleLabel;
    }

    protected Color getBackground() {
        return ThemeUtils.getCurrentTheme().getWidgetBackgroundColor();
    }

    protected ObjectFieldDefinitionComposite createObjectFieldDefComp(Composite parent) {
        ObjectFieldDefinitionComposite objectFieldDefinitionComposite = new ObjectFieldDefinitionComposite(parent, 0, 512);
        TreeViewer payloadTreeViewer = objectFieldDefinitionComposite.getPayloadTreeViewer();
        payloadTreeViewer.setContentProvider((IContentProvider)new ObjectFieldDefinitionTreeContentProvider());
        payloadTreeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TreeNodeLabelProvider()));
        payloadTreeViewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (!selection.isEmpty()) {
                IStructuredSelection treeSelection = (IStructuredSelection)selection;
                TreeNode node = (TreeNode)treeSelection.getFirstElement();
                ObjectFieldDefinition def = (ObjectFieldDefinition)node.getValue();
                this.objectFieldDefComp.setSelectionTextValue(def.getValue());
            } else {
                this.objectFieldDefComp.setSelectionTextValue("");
            }
        });
        return objectFieldDefinitionComposite;
    }

    private void drawTheTreeViewerFrom(ObjectFieldDefinition definition) {
        TreeViewer payloadTreeViewer = this.objectFieldDefComp.getPayloadTreeViewer();
        TreeNode createdTreeNode = ObjectTreeNodeBuilder.createTreeNode(definition);
        TreeNode[] input = new TreeNode[]{createdTreeNode};
        payloadTreeViewer.setInput((Object)input);
        payloadTreeViewer.expandToLevel(2);
        payloadTreeViewer.setSelection((ISelection)new StructuredSelection((Object)createdTreeNode));
    }

    protected Control createInputExpressionArea(Composite parent) {
        this.scriptEditorComposite = new ScriptEditorComposite(parent, 0, 6);
        this.scriptHistory = new History(DebuggerPreferences.amountOfItemsInHistory());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.scriptEditorComposite);
        new ScriptEditorController(this.scriptHistory, this.viewMenuButton, this.scriptEditorComposite);
        this.scriptEditorComposite.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if ('\u001b' == e.character) {
                this.dispose();
            }
        }));
        Composite searchTextFieldComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)searchTextFieldComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(searchTextFieldComposite);
        this.clearLabel = this.createButton(searchTextFieldComposite, "Clear", () -> {
            this.scriptEditorComposite.getEditor().setTextDocument("");
            TreeViewer payloadTreeViewer = this.objectFieldDefComp.getPayloadTreeViewer();
            payloadTreeViewer.setInput(null);
        });
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.clearLabel);
        this.evaluateLabel = this.createButton(searchTextFieldComposite, "Evaluate", () -> {
            String script = this.scriptEditorComposite.getEditor().getTextDocument();
            this.scriptHistory.addHistory(script);
            this.drawTheTreeViewerFrom(new ObjectFieldDefinition("Evaluating...", null, "(" + script + ")", Collections.emptyList(), 0, new FieldPath(""), false, null));
            MuleDebuggerService service = MuleDebuggerService.getDefault();
            service.getDebuggerClient().executeScript(script, service.getCurrentMuleMessageInfoId(), (IDebuggerResponseCallback)new ScriptEvaluationDebuggerCallback());
        });
        GridDataFactory.fillDefaults().indent(50, 0).align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)this.evaluateLabel);
        this.addLabel = this.createButton(searchTextFieldComposite, "Add watch", () -> {
            String script = this.scriptEditorComposite.getEditor().getTextDocument();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart view = page.findView("org.mule.tooling.ui.contribution.debugger.view");
            if (view instanceof MuleDebuggerView) {
                AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.ADD_WATCH).addMetadata("from", "popup").addMetadata("script", script).track();
                ((MuleDebuggerView)view).addExpressionWatch(script);
            }
        });
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)this.addLabel);
        return this.scriptEditorComposite;
    }

    private Button createButton(Composite searchTextFieldComposite, String label, final Runnable onMouseDown) {
        Button button = new Button(searchTextFieldComposite, 8);
        button.setText(label);
        button.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                onMouseDown.run();
            }
        });
        return button;
    }

    protected IDialogSettings getDialogSettings() {
        return settings;
    }

    protected Point getDefaultSize() {
        return new Point(350, 350);
    }

    protected Control getFocusControl() {
        return this.scriptEditorComposite;
    }

    public void dispose() {
        this.close();
    }

    private class PinAction
    extends Action {
        public PinAction() {
            super("Pin", 2);
            this.setChecked(ScriptEvaluatePopupDialog.this.lastPin);
        }

        public void run() {
            ScriptEvaluatePopupDialog.this.lastPin = ScriptEvaluatePopupDialog.this.pin = this.isChecked();
        }
    }

    private final class ScriptEvaluationDebuggerCallback
    extends DefaultDebuggerResponseCallback {
        private ScriptEvaluationDebuggerCallback() {
        }

        public void onScriptEvaluation(ScriptResultInfo info) {
            ObjectFieldDefinition excResultDef = info.getResult();
            this.draw(excResultDef);
        }

        public void onScriptEvaluationException(RemoteDebugException exception) {
            ObjectFieldDefinition excResultDef = exception.getException();
            this.draw(excResultDef);
        }

        private void draw(ObjectFieldDefinition definition) {
            Display.getDefault().asyncExec(() -> ScriptEvaluatePopupDialog.this.drawTheTreeViewerFrom(definition));
        }
    }

    private static class Singleton {
        private static final ScriptEvaluatePopupDialog instance = new ScriptEvaluatePopupDialog(Display.getDefault().getActiveShell());

        private Singleton() {
        }
    }
}

