/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.impl;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.ui.contribution.debugger.controller.ExpressionFieldDefinition;
import org.mule.tooling.ui.contribution.debugger.controller.WatchesController;
import org.mule.tooling.ui.contribution.debugger.view.impl.ObjectFieldDefinitionComposite;

public class RemoveExpressionFromWatches
extends Action {
    private WatchesController watchesController;
    private TreeViewer treeViewer;

    public RemoveExpressionFromWatches(ObjectFieldDefinitionComposite definitionComposite, WatchesController watchesController) {
        this.watchesController = watchesController;
        this.treeViewer = definitionComposite.getPayloadTreeViewer();
        this.treeViewer.addSelectionChangedListener(event -> this.setEnabled(this.hasExpressionSelected()));
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE"));
        this.setToolTipText("Remove expression from watches");
        this.setText("Remove expression from watches");
        this.setEnabled(false);
    }

    public void run() {
        Display.getDefault().asyncExec(() -> {
            StructuredSelection selection = (StructuredSelection)this.treeViewer.getSelection();
            TreeNode node = (TreeNode)selection.getFirstElement();
            this.watchesController.removeExpressionWatch(node);
        });
    }

    private boolean hasExpressionSelected() {
        StructuredSelection selection = (StructuredSelection)this.treeViewer.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        TreeNode node = (TreeNode)selection.getFirstElement();
        return node.getValue() instanceof ExpressionFieldDefinition;
    }
}

