/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.impl;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.ui.contribution.debugger.view.IObjectFieldDefinitionEditor;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerWidgetsBuilder;

public class ObjectFieldDefinitionComposite
extends Composite
implements IObjectFieldDefinitionEditor {
    private static final RGB errorForegroundColor = new RGB(209, 52, 78);
    private static final RGB errorBackgroundColor = new RGB(250, 231, 231);
    private Text valueText;
    private TreeViewer payloadTreeViewer;
    private Color originalBackgroundColor;
    private Color originalForegroundColor;

    public ObjectFieldDefinitionComposite(Composite parent, int style, int orientation) {
        super(parent, style);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this);
        this.createControl(this, orientation);
    }

    protected void createControl(Composite parent, int orientation) {
        SashForm form = new SashForm(parent, orientation);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)form);
        this.setPayloadTreeViewer(DebuggerWidgetsBuilder.createObjectDefinitionTreeTable((Composite)form));
        this.setValueText(new Text((Composite)form, 2626));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.getValueText());
        this.getValueText().setFont(JFaceResources.getTextFont());
        this.getValueText().setEditable(false);
        form.setWeights(new int[]{5, 5});
        if (256 == orientation) {
            form.setWeights(new int[]{8, 2});
        }
    }

    private void setPayloadTreeViewer(TreeViewer payloadTreeViewer) {
        this.payloadTreeViewer = payloadTreeViewer;
    }

    @Override
    public TreeViewer getPayloadTreeViewer() {
        return this.payloadTreeViewer;
    }

    @Override
    public void setSelectionTextValue(String value) {
        if (value != null) {
            this.getValueText().setText(value);
            if (this.originalForegroundColor != null) {
                this.getValueText().setForeground(this.originalForegroundColor);
            }
            if (this.originalBackgroundColor != null) {
                this.getValueText().setBackground(this.originalBackgroundColor);
            }
        }
    }

    @Override
    public void setSelectionTextErrorValue(String value) {
        if (!this.getValueText().getBackground().equals((Object)new Color((Device)Display.getCurrent(), errorBackgroundColor))) {
            this.originalBackgroundColor = this.getValueText().getBackground();
            this.originalForegroundColor = this.getValueText().getForeground();
            this.setTextColors(new Color((Device)Display.getCurrent(), errorForegroundColor), new Color((Device)Display.getCurrent(), errorBackgroundColor));
        }
        this.setText(value);
    }

    private void setTextColors(Color foreground, Color background) {
        this.getValueText().setForeground(foreground);
        this.getValueText().setBackground(background);
    }

    private void setText(String value) {
        if (value != null) {
            this.getValueText().setText(value);
        }
    }

    private void setValueText(Text valueText) {
        this.valueText = valueText;
    }

    public Text getValueText() {
        return this.valueText;
    }
}

