/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.impl;

import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerResponseCallback;
import org.mule.tooling.ui.contribution.debugger.controller.ExpressionFieldDefinition;
import org.mule.tooling.ui.contribution.debugger.controller.MuleDebuggerMuleMessageController;
import org.mule.tooling.ui.contribution.debugger.controller.MuleDebuggerViewController;
import org.mule.tooling.ui.contribution.debugger.controller.WatchesController;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.IMuleDebuggerEditor;
import org.mule.tooling.ui.contribution.debugger.view.actions.ConnectAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.DisconnectAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.NextStepAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.OpenScriptEvaluatePopupAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.ResumeAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.RunToProcessorAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.TerminateCurrentLaunchAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.ToggleSchedulerAction;
import org.mule.tooling.ui.contribution.debugger.view.impl.AddExpressionToWatches;
import org.mule.tooling.ui.contribution.debugger.view.impl.ObjectFieldDefinitionComposite;
import org.mule.tooling.ui.contribution.debugger.view.impl.RemoveAllExpressionsFromWatches;
import org.mule.tooling.ui.contribution.debugger.view.impl.RemoveExpressionFromWatches;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;

public class MuleDebuggerView
extends ViewPart
implements IMuleDebuggerEditor {
    private static final String MULE_DEBUGGER_TOOLTIP = "View message data by running your application in Mule Debug mode";
    private static final String WAITING_MULE_MESSAGE_MESSAGE = "- Connected with Mule. Waiting for a Mule message to arrive.";
    private static final String DEBUGGER_NOT_CONNECTED_MESSAGE = "- Mule Debugger is not running. Launch your Mule application in debug.";
    private static final String ENABLE_DEBUGGER_CONNECTION_ACTIONS = "studio.enableDebuggerConnectionActions";
    public static final String DEBUGGER_VIEW = "org.mule.tooling.ui.contribution.debugger.view";
    private final EventBusHelper eventBusHelper = new EventBusHelper();
    private ObjectFieldDefinitionComposite muleDebuggerComposite;
    private EventBus eventBus;
    private Composite debuggerEditor;
    private StackLayout debuggerEditorLayout;
    private SashForm messageView;
    private MuleDebuggerMuleMessageController muleMessageController;
    private TerminateCurrentLaunchAction terminateAction;
    private ToggleSchedulerAction startSchedulerAction;
    private ToggleSchedulerAction stopSchedulerAction;
    private WatchesController watchesController;
    private Label debuggerStateLabel;
    private Group messageGroup;

    public void createPartControl(Composite parent) {
        this.eventBus = MuleDebuggerService.getDefault().getEventBus();
        Composite editor = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 2;
        fillLayout.marginHeight = 2;
        editor.setLayout((Layout)fillLayout);
        this.debuggerEditor = new Composite(editor, 0);
        this.debuggerEditorLayout = new StackLayout();
        this.debuggerEditor.setLayout((Layout)this.debuggerEditorLayout);
        this.messageView = new SashForm(this.debuggerEditor, 0);
        this.debuggerEditorLayout.topControl = this.messageView;
        this.messageGroup = new Group((Composite)this.messageView, 0);
        this.messageGroup.setLayout((Layout)new GridLayout(1, false));
        this.messageGroup.setLayoutData((Object)new GridData(768));
        Composite titleComposite = new Composite((Composite)this.messageGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(-1, -1).applyTo(titleComposite);
        Label mainLabel = new Label(titleComposite, 0);
        mainLabel.setText("Variables and watches ");
        FontData fontData = mainLabel.getFont().getFontData()[0];
        mainLabel.setFont(new Font((Device)Display.getCurrent(), new FontData(fontData.getName(), fontData.getHeight(), 1)));
        this.debuggerStateLabel = new Label(titleComposite, 0);
        this.debuggerStateLabel.setText(DEBUGGER_NOT_CONNECTED_MESSAGE);
        this.muleDebuggerComposite = new ObjectFieldDefinitionComposite((Composite)this.messageGroup, 0, 256);
        this.muleDebuggerComposite.setLayoutData(new GridData(1808));
        this.muleMessageController = new MuleDebuggerMuleMessageController(this.muleDebuggerComposite, this.eventBus);
        this.watchesController = new WatchesController(this.muleDebuggerComposite, this.eventBus);
        MuleDebuggerService.getDefault().getExpressionWacthesService().loadPersistedMarkersIfNotLoaded();
        this.createToolBar();
        this.setTitleToolTip(MULE_DEBUGGER_TOOLTIP);
        new MuleDebuggerViewController(this, this.eventBus);
    }

    public void addExpressionWatch(String expression) {
        this.watchesController.addExpressionWatch(expression);
    }

    public void addExpressionWatchFromMarker(ExpressionFieldDefinition expression) {
        this.watchesController.addExpressionWatchFromMarker(expression);
    }

    public void createToolBar() {
        IToolBarManager mgr = this.getToolBarManager();
        this.terminateAction = new TerminateCurrentLaunchAction(this.eventBus);
        mgr.add((IAction)this.terminateAction);
        mgr.add((IAction)new OpenScriptEvaluatePopupAction(this.eventBus));
        if (System.getProperties().containsKey(ENABLE_DEBUGGER_CONNECTION_ACTIONS)) {
            mgr.add((IAction)new ConnectAction(this.eventBus, (IDebuggerResponseCallback)new DebuggerResponseCallback(this.eventBus)));
            mgr.add((IAction)new DisconnectAction(this.eventBus));
        }
        mgr.add((IAction)new NextStepAction(this.eventBus));
        mgr.add((IAction)new RunToProcessorAction(this.eventBus));
        mgr.add((IAction)new ResumeAction(this.eventBus));
        this.startSchedulerAction = new ToggleSchedulerAction(ToggleSchedulerAction.SchedulerAction.START_SCHEDULER);
        this.startSchedulerAction.setEnabled(false);
        mgr.add((IAction)this.startSchedulerAction);
        this.stopSchedulerAction = new ToggleSchedulerAction(ToggleSchedulerAction.SchedulerAction.STOP_SCHEDULER);
        this.stopSchedulerAction.setEnabled(false);
        mgr.add((IAction)this.stopSchedulerAction);
        mgr.add((IAction)new AddExpressionToWatches(this.getSite().getShell(), this.watchesController));
        mgr.add((IAction)new RemoveExpressionFromWatches(this.muleDebuggerComposite, this.watchesController));
        mgr.add((IAction)new RemoveAllExpressionsFromWatches(this.watchesController));
    }

    private IToolBarManager getToolBarManager() {
        return this.getViewSite().getActionBars().getToolBarManager();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.eventBus.cleanAllListeners();
        this.muleMessageController.dispose();
        this.eventBusHelper.unregister();
        this.debuggerEditor = null;
        this.watchesController.dispose();
    }

    @Override
    public void setDebuggerConnected(Boolean enabled) {
        this.showDebuggerConnectionState(enabled);
        this.setActionState(this.terminateAction, enabled);
        this.setActionState(this.stopSchedulerAction, enabled);
        this.setActionState(this.startSchedulerAction, enabled);
    }

    private void showDebuggerConnectionState(Boolean enabled) {
        if (enabled.booleanValue()) {
            this.debuggerStateLabel.setText(WAITING_MULE_MESSAGE_MESSAGE);
        } else {
            this.debuggerStateLabel.setText(DEBUGGER_NOT_CONNECTED_MESSAGE);
        }
        this.debuggerEditor.layout();
    }

    private void setActionState(Action action, boolean enabled) {
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    @Override
    public void setDebuggerResumed(Boolean waiting) {
        this.showDebuggerState(waiting);
    }

    private void showDebuggerState(Boolean waiting) {
        if (waiting.booleanValue()) {
            this.debuggerStateLabel.setText(WAITING_MULE_MESSAGE_MESSAGE);
        } else {
            this.debuggerStateLabel.setText("");
        }
        this.debuggerEditor.layout();
    }
}

