/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.impl;

import java.util.Arrays;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.ViewPart;
import org.mule.tooling.ui.contribution.debugger.controller.MuleBreakpointsController;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.actions.EnableExceptionBreakpointAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.MuteBreakpointsAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.RemoveAllBreakpointsAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.RemoveBreakpointAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.SortBreakpointsAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.SortByBreakpointsAction;
import org.mule.tooling.ui.contribution.debugger.view.impl.MuleBreakpointEditorImpl;
import org.mule.tooling.utils.eventbus.EventBus;

public class MuleBreakpointsView
extends ViewPart {
    public static final String VIEW_ID = "org.mule.tooling.ui.contribution.debugger.breakpoints";
    private MuleBreakpointsController muleBPController;

    public void createPartControl(Composite parent) {
        EventBus eventBus = MuleDebuggerService.getDefault().getEventBus();
        MuleBreakpointEditorImpl muleBreakpointEditorImpl = new MuleBreakpointEditorImpl(parent, 0);
        this.muleBPController = new MuleBreakpointsController(muleBreakpointEditorImpl, eventBus);
        this.createToolBar(muleBreakpointEditorImpl);
    }

    public void createToolBar(MuleBreakpointEditorImpl muleBreakpointEditorImpl) {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)new MuteBreakpointsAction());
        mgr.add((IAction)new EnableExceptionBreakpointAction());
        mgr.add((IAction)new RemoveAllBreakpointsAction());
        mgr.add((IAction)new RemoveBreakpointAction(muleBreakpointEditorImpl));
        SortByBreakpointsAction sortByAction = new SortByBreakpointsAction((Control)((ToolBarManager)mgr).getControl());
        Arrays.asList(SortBreakpointsAction.BreakpointComparator.values()).forEach(comparator -> sortByAction.addAction(new SortBreakpointsAction(muleBreakpointEditorImpl, (SortBreakpointsAction.BreakpointComparator)((Object)comparator))));
        mgr.add((IAction)sortByAction);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.muleBPController.dispose();
    }
}

