/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.impl;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.mule.tooling.ui.contribution.debugger.view.IMuleBreakpointEditor;
import org.mule.tooling.ui.contribution.debugger.view.impl.ScriptEditorComposite;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class MuleBreakpointEditorImpl
extends Composite
implements IMuleBreakpointEditor {
    private CheckboxTableViewer breakpointsTblViewer;
    private Button conditional;
    private ScriptEditorComposite conditionalScript;
    private Composite conditionalScriptEditor;
    private StackLayout conditionalScriptEditorLayout;
    private Composite noScriptLayout;

    public MuleBreakpointEditorImpl(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.createControl(this);
    }

    public void createControl(Composite parent) {
        this.breakpointsTblViewer = this.createBreakpointTable(parent);
        this.conditional = new Button(parent, 32);
        this.conditional.setText("Conditional");
        this.conditionalScriptEditor = new Composite(parent, 0);
        this.conditionalScriptEditorLayout = new StackLayout();
        this.conditionalScriptEditor.setLayout((Layout)this.conditionalScriptEditorLayout);
        this.conditionalScriptEditor.setLayoutData((Object)new GridData(768));
        this.noScriptLayout = this.createNoScriptLayout(this.conditionalScriptEditor);
        this.conditionalScriptEditorLayout.topControl = this.noScriptLayout;
        this.conditionalScriptEditor.layout();
    }

    private Composite createNoScriptLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        ThemeUtils.setCssClass((Object)composite, (String)"disabled-page");
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Composite centeredComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(centeredComposite);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).hint(-1, WidgetUtils.getLinesHeightInPixels((Control)centeredComposite, (int)4)).grab(true, true).applyTo((Control)centeredComposite);
        return composite;
    }

    public CheckboxTableViewer createBreakpointTable(final Composite parent) {
        final CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        final TableColumn idColumn = new TableColumn(tableViewer.getTable(), 16384, 0);
        idColumn.setText("Element");
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point preferredSize = tableViewer.getTable().computeSize(-1, -1);
                int scrollBarWidth = 13;
                int width = area.width - 2 * tableViewer.getTable().getBorderWidth() - scrollBarWidth;
                if (preferredSize.y > area.height + tableViewer.getTable().getHeaderHeight()) {
                    Point vBarSize = tableViewer.getTable().getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                idColumn.setWidth(width);
                tableViewer.getTable().setSize(area.width, area.height);
            }
        });
        return tableViewer;
    }

    @Override
    public CheckboxTableViewer getBreakpointTable() {
        return this.breakpointsTblViewer;
    }

    @Override
    public Button getConditional() {
        return this.conditional;
    }

    @Override
    public ScriptEditorComposite createConditionalScript() {
        SashForm scriptLayout = new SashForm(this.conditionalScriptEditor, 0);
        this.conditionalScript = new ScriptEditorComposite((Composite)scriptLayout, 0, 4);
        this.conditionalScript.setLayoutData(new GridData(768));
        this.conditionalScriptEditorLayout.topControl = scriptLayout;
        this.conditionalScriptEditor.layout();
        return this.conditionalScript;
    }

    @Override
    public ScriptEditorComposite getConditionalScript() {
        return this.conditionalScript;
    }

    @Override
    public void removeConditionalScript() {
        this.conditionalScript.dispose();
        this.conditionalScript = null;
        this.conditionalScriptEditorLayout.topControl = this.noScriptLayout;
        this.conditionalScriptEditor.layout();
    }
}

