/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.impl;

import com.mulesoft.mule.debugger.dto.FieldPath;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.dto.ScriptResultInfo;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.response.callback.DefaultDebuggerResponseCallback;
import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import java.util.Collections;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerEventTypes;
import org.mule.tooling.ui.contribution.debugger.controller.ObjectFieldDefinitionTreeContentProvider;
import org.mule.tooling.ui.contribution.debugger.controller.ObjectTreeNodeBuilder;
import org.mule.tooling.ui.contribution.debugger.controller.ScriptEditorController;
import org.mule.tooling.ui.contribution.debugger.controller.TreeNodeLabelProvider;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerConnectedHandler;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerDisconnectedHandler;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerResumedHandler;
import org.mule.tooling.ui.contribution.debugger.controller.events.INewMuleMessageArrivedHandler;
import org.mule.tooling.ui.contribution.debugger.preferences.DebuggerPreferences;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerImages;
import org.mule.tooling.ui.contribution.debugger.view.impl.MuleDebuggerView;
import org.mule.tooling.ui.contribution.debugger.view.impl.ObjectFieldDefinitionComposite;
import org.mule.tooling.ui.contribution.debugger.view.impl.ScriptEditorComposite;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.text.History;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class EvaluateView
extends ViewPart {
    public static final String VIEW_ID = "org.mule.tooling.ui.contribution.debugger.evaluate";
    private static final String DEBUGGER_NOT_CONNECTED_MESSAGE = "Mule Debugger is not running.\nLaunch your Mule application in debug.";
    private static final int SCRIPT_EDITOR_MIN_SIZE = 200;
    private History scriptHistory;
    private ObjectFieldDefinitionComposite definitionComposite;
    private ScriptEditorComposite scriptEditorComposite;
    private Button evaluateButton;
    private Button addToWatchesButton;
    private Button clearButton;
    private ToolItem viewMenuButton;
    private Composite unconnectedComposite;
    private Composite evaluateEditor;
    private StackLayout evaluateEditorLayout;
    private SashForm evaluateView;
    private Composite conditionalScriptEditor;
    private StackLayout conditionalScriptEditorLayout;
    private Composite noScriptLayout;
    private ScriptEditorController scriptEditorController;
    private IDebuggerResumedHandler resumedListener;
    private IDebuggerDisconnectedHandler disconnectedListener;
    private INewMuleMessageArrivedHandler muleMessageArrivedListener;
    private IDebuggerConnectedHandler connectedListener;

    public void createPartControl(Composite parent) {
        this.evaluateEditor = new Composite(parent, 0);
        this.evaluateEditorLayout = new StackLayout();
        this.evaluateEditor.setLayout((Layout)this.evaluateEditorLayout);
        Image disabledDebuggerImage = DebuggerImages.getDebuggerImages().getImageByPath("icons/large/disabled-debugger-78x78.png");
        this.unconnectedComposite = UiUtils.createDisabledComposite((Composite)this.evaluateEditor, (String)DEBUGGER_NOT_CONNECTED_MESSAGE, (Image)disabledDebuggerImage);
        this.evaluateEditorLayout.topControl = this.unconnectedComposite;
        this.evaluateView = new SashForm(this.evaluateEditor, 0);
        Group evalGroup = new Group((Composite)this.evaluateView, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        evalGroup.setLayout((Layout)layout);
        this.createToolBar(evalGroup);
        this.createScriptEditorComposite((Composite)evalGroup);
        this.definitionComposite = this.createDefinitionComposite(evalGroup);
        this.definitionComposite.setLayoutData(new GridData(1808));
    }

    private void createToolBar(Group evalGroup) {
        ToolBar toolBar = new ToolBar((Composite)evalGroup, 0x800100);
        this.viewMenuButton = new ToolItem(toolBar, 4);
        this.viewMenuButton.setText("Script History");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)toolBar);
    }

    private ObjectFieldDefinitionComposite createDefinitionComposite(Group evalGroup) {
        ObjectFieldDefinitionComposite definitionComposite = new ObjectFieldDefinitionComposite((Composite)evalGroup, 0, 512);
        TreeViewer payloadTreeViewer = definitionComposite.getPayloadTreeViewer();
        payloadTreeViewer.setContentProvider((IContentProvider)new ObjectFieldDefinitionTreeContentProvider());
        payloadTreeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TreeNodeLabelProvider()));
        payloadTreeViewer.addSelectionChangedListener(event -> this.onSelectionChanged(definitionComposite, event));
        return definitionComposite;
    }

    private void onSelectionChanged(ObjectFieldDefinitionComposite definitionComposite, SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!selection.isEmpty()) {
            IStructuredSelection treeSelection = (IStructuredSelection)selection;
            TreeNode node = (TreeNode)treeSelection.getFirstElement();
            ObjectFieldDefinition def = (ObjectFieldDefinition)node.getValue();
            definitionComposite.setSelectionTextValue(def.getValue());
        } else {
            definitionComposite.setSelectionTextValue("");
        }
    }

    private Composite createNoScriptLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).hint(-1, WidgetUtils.getLinesHeightInPixels((Control)composite, (int)7)).grab(true, true).applyTo((Control)composite);
        return composite;
    }

    protected Composite createScriptEditorComposite(Composite parent) {
        this.conditionalScriptEditor = new Composite(parent, 0);
        this.conditionalScriptEditorLayout = new StackLayout();
        this.conditionalScriptEditor.setLayout((Layout)this.conditionalScriptEditorLayout);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 200).applyTo((Control)this.conditionalScriptEditor);
        this.noScriptLayout = this.createNoScriptLayout(this.conditionalScriptEditor);
        if (MuleDebuggerService.getDefault().isDebugging()) {
            this.scriptEditorComposite = this.createConditionalScript();
            this.evaluateEditorLayout.topControl = this.evaluateView;
            this.evaluateEditor.layout();
        } else {
            this.conditionalScriptEditorLayout.topControl = this.noScriptLayout;
            this.conditionalScriptEditor.layout();
        }
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(3, false));
        this.clearButton = this.createButton(buttonComposite, "Clear", () -> this.onClearButtonPressed());
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.clearButton);
        this.evaluateButton = this.createButton(buttonComposite, "Evaluate", () -> this.onEvaluateButtonPressed());
        this.evaluateButton.setEnabled(false);
        GridDataFactory.fillDefaults().indent(10, 0).align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)this.evaluateButton);
        this.registerListenersForEvaluateButton();
        this.addToWatchesButton = this.createButton(buttonComposite, "Add to watch", () -> this.onAddToWatchesButtonPressed());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)this.addToWatchesButton);
        return this.conditionalScriptEditor;
    }

    public ScriptEditorComposite createConditionalScript() {
        SashForm scriptLayout = new SashForm(this.conditionalScriptEditor, 0);
        ScriptEditorComposite conditionalScript = new ScriptEditorComposite((Composite)scriptLayout, 0, 7);
        this.scriptHistory = new History(DebuggerPreferences.amountOfItemsInHistory());
        this.scriptEditorController = new ScriptEditorController(this.scriptHistory, this.viewMenuButton, conditionalScript);
        conditionalScript.setLayoutData(new GridData(768));
        this.conditionalScriptEditorLayout.topControl = scriptLayout;
        this.conditionalScriptEditor.layout();
        return conditionalScript;
    }

    public void deleteConditionalScript() {
        this.scriptEditorController.dispose();
        this.scriptEditorComposite.dispose();
    }

    private void onClearButtonPressed() {
        this.scriptEditorComposite.getEditor().setTextDocument("");
        this.definitionComposite.getPayloadTreeViewer().setInput(null);
    }

    private void onEvaluateButtonPressed() {
        String script = this.scriptEditorComposite.getEditor().getTextDocument();
        this.scriptHistory.addHistory(script);
        this.drawTheTreeViewerFrom(new ObjectFieldDefinition("Evaluating...", null, "(" + script + ")", Collections.emptyList(), 0, new FieldPath(""), false, null));
        MuleDebuggerService service = MuleDebuggerService.getDefault();
        service.getDebuggerClient().executeScript(script, service.getCurrentMuleMessageInfoId(), (IDebuggerResponseCallback)new ScriptEvaluationDebuggerCallback());
    }

    private void onAddToWatchesButtonPressed() {
        String script = this.scriptEditorComposite.getEditor().getTextDocument();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = page.findView("org.mule.tooling.ui.contribution.debugger.view");
        if (view instanceof MuleDebuggerView) {
            ((MuleDebuggerView)view).addExpressionWatch(script);
        }
    }

    private void registerListenersForEvaluateButton() {
        EventBus eventBus = MuleDebuggerService.getDefault().getEventBus();
        this.resumedListener = () -> Display.getDefault().asyncExec(() -> this.evaluateButton.setEnabled(false));
        eventBus.registerListener(DebuggerEventTypes.RESUMED, (IEventHandler)this.resumedListener);
        this.disconnectedListener = () -> Display.getDefault().asyncExec(() -> {
            this.evaluateButton.setEnabled(false);
            this.definitionComposite.getPayloadTreeViewer().setInput(null);
            this.deleteConditionalScript();
            this.evaluateEditorLayout.topControl = this.unconnectedComposite;
            this.evaluateEditor.layout();
        });
        eventBus.registerListener(DebuggerEventTypes.DISCONNECTED, (IEventHandler)this.disconnectedListener);
        this.muleMessageArrivedListener = (muleMessageInfo, exceptionThrown) -> Display.getDefault().asyncExec(() -> this.evaluateButton.setEnabled(true));
        eventBus.registerListener(DebuggerEventTypes.MULE_MESSAGE_ARRIVED, (IEventHandler)this.muleMessageArrivedListener);
        this.connectedListener = () -> Display.getDefault().asyncExec(() -> {
            this.scriptEditorComposite = this.createConditionalScript();
            this.evaluateEditorLayout.topControl = this.evaluateView;
            this.evaluateEditor.layout();
        });
        eventBus.registerListener(DebuggerEventTypes.CONNECTED, (IEventHandler)this.connectedListener);
    }

    private void unregisterListenersForEvaluateButton() {
        EventBus eventBus = MuleDebuggerService.getDefault().getEventBus();
        eventBus.unRegisterListener(DebuggerEventTypes.RESUMED, (IEventHandler)this.resumedListener);
        eventBus.unRegisterListener(DebuggerEventTypes.DISCONNECTED, (IEventHandler)this.disconnectedListener);
        eventBus.unRegisterListener(DebuggerEventTypes.MULE_MESSAGE_ARRIVED, (IEventHandler)this.muleMessageArrivedListener);
        eventBus.unRegisterListener(DebuggerEventTypes.CONNECTED, (IEventHandler)this.connectedListener);
    }

    private Button createButton(Composite buttonComposite, String label, Runnable onMouseDown) {
        Button button = new Button(buttonComposite, 8);
        button.setText(label);
        button.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
        button.addMouseListener(MouseListener.mouseDownAdapter(e -> onMouseDown.run()));
        return button;
    }

    private void drawTheTreeViewerFrom(ObjectFieldDefinition definition) {
        TreeViewer payloadTreeViewer = this.definitionComposite.getPayloadTreeViewer();
        TreeNode createdTreeNode = ObjectTreeNodeBuilder.createTreeNode(definition);
        TreeNode[] input = new TreeNode[]{createdTreeNode};
        payloadTreeViewer.setInput((Object)input);
        payloadTreeViewer.expandToLevel(2);
        payloadTreeViewer.setSelection((ISelection)new StructuredSelection((Object)createdTreeNode));
    }

    public void dispose() {
        super.dispose();
        this.unregisterListenersForEvaluateButton();
    }

    public void setFocus() {
    }

    public void changeHistorySize(int newValue) {
        this.scriptHistory.changeSize(newValue);
    }

    private final class ScriptEvaluationDebuggerCallback
    extends DefaultDebuggerResponseCallback {
        private ScriptEvaluationDebuggerCallback() {
        }

        public void onScriptEvaluation(ScriptResultInfo info) {
            ObjectFieldDefinition excResultDef = info.getResult();
            this.draw(excResultDef);
        }

        public void onScriptEvaluationException(RemoteDebugException exception) {
            ObjectFieldDefinition excResultDef = exception.getException();
            this.draw(excResultDef);
        }

        private void draw(ObjectFieldDefinition definition) {
            Display.getDefault().asyncExec(() -> {
                EvaluateView.this.evaluateButton.setEnabled(true);
                EvaluateView.this.drawTheTreeViewerFrom(definition);
            });
        }
    }
}

