/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.impl;

import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.dto.ScriptResultInfo;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.response.callback.DefaultDebuggerResponseCallback;
import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.debug.ui.actions.OpenTypeAction;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.ui.contribution.debugger.controller.CurrentOperationFieldDefinition;
import org.mule.tooling.ui.contribution.debugger.controller.ExpressionFieldDefinition;
import org.mule.tooling.ui.contribution.debugger.controller.MuleDebuggerMuleMessageController;
import org.mule.tooling.ui.contribution.debugger.controller.ScriptEvaluationDebuggerCallback;
import org.mule.tooling.ui.contribution.debugger.controller.TreeNodeLabelProvider;
import org.mule.tooling.ui.contribution.debugger.preferences.DebuggerPreferences;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.utils.FlowEditorEntityEditPartPair;
import org.mule.tooling.ui.contribution.debugger.utils.MuleDebuggerUtils;
import org.mule.tooling.ui.contribution.debugger.view.impl.MuleDebuggerView;
import org.mule.tooling.ui.contribution.debugger.view.impl.MuleExpressionInputDialog;
import org.mule.tooling.ui.contribution.debugger.view.impl.UpdateExpressionController;
import org.mule.tooling.ui.contribution.debugger.view.impl.UpdateExpressionEditor;
import org.mule.tooling.ui.widgets.dialog.ISimpleDialogEditorPresenter;
import org.mule.tooling.ui.widgets.dialog.SimpleEditorDialog;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class DebuggerWidgetsBuilder {
    private static final int NAME_COLUMN_WIDTH = 10;
    private static final String ELIPSIS_SUFFIX = "...";
    private static final int MAXIMUM_CHAR_WIDGET_SUPPORT = 250;
    private static Set<String> COPY_VALUE_ACCEPTED_RAW_MIME_TYPES = Stream.of("application/json", "application/xml", "application/csv", "text/plain").collect(Collectors.toSet());
    private static String COPY_VALUE_EXPRESSION_TEMPLATE = "output %s \n---\n %s";

    public static TreeViewer createObjectDefinitionTreeTable(Composite parent) {
        final Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new FillLayout());
        TreeViewer treeViewer = new TreeViewer(composite, 0x10010300);
        final Tree tree = treeViewer.getTree();
        final TreeColumn nameCol = DebuggerWidgetsBuilder.createNameColumn(treeViewer, tree);
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = composite.getClientArea();
                Point preferredSize = tree.computeSize(-1, -1);
                int scrollBarWidth = 4;
                int width = area.width - 2 * tree.getBorderWidth() - scrollBarWidth;
                if (preferredSize.y > area.height + tree.getHeaderHeight()) {
                    Point vBarSize = tree.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = tree.getSize();
                if (oldSize.x > area.width) {
                    nameCol.setWidth(width);
                    tree.setSize(area.width, area.height);
                } else {
                    tree.setSize(area.width, area.height);
                    nameCol.setWidth(width);
                }
            }
        });
        treeViewer.setComparator((ViewerComparator)new ObjectFieldDefinitionViewerComparator());
        treeViewer.addDoubleClickListener((IDoubleClickListener)new TreeExpanderCollapserDoubleClickListener());
        treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreeNode treeNode = (TreeNode)event.getElement();
                ObjectFieldDefinition definition = (ObjectFieldDefinition)treeNode.getValue();
                AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.VARIABLES).addMetadata("operation", "expanded").addMetadata("variableName", definition.getName()).track();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                TreeNode treeNode = (TreeNode)event.getElement();
                ObjectFieldDefinition definition = (ObjectFieldDefinition)treeNode.getValue();
                AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.VARIABLES).addMetadata("operation", "collapsed").addMetadata("variableName", definition.getName()).track();
            }
        });
        DebuggerWidgetsBuilder.createContextMenu(treeViewer, tree);
        return treeViewer;
    }

    private static void createContextMenu(final TreeViewer treeViewer, Tree tree) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
                TreeNode treeNode = (TreeNode)selection.getFirstElement();
                ObjectFieldDefinition definition = (ObjectFieldDefinition)treeNode.getValue();
                if (definition instanceof CurrentOperationFieldDefinition) {
                    manager.add((IAction)new FocusElementAction((CurrentOperationFieldDefinition)definition));
                } else {
                    if (definition instanceof ExpressionFieldDefinition) {
                        manager.add((IAction)new UpdateExpressionAction(definition, treeNode, (ColumnViewer)treeViewer));
                    } else {
                        manager.add((IAction)new UpdateValueAction(definition, treeNode, (ColumnViewer)treeViewer));
                    }
                    manager.add((IAction)new GoToClassAction(definition));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new CopyDWAccessorAction(definition));
                    manager.add((IAction)new AddWatchAction(definition));
                    manager.add((IAction)new CopyValueAction(definition));
                }
                manager.update(true);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)tree);
        tree.setMenu(menu);
    }

    private static TreeColumn createNameColumn(TreeViewer treeViewer, Tree tree) {
        TreeColumn nameCol = new TreeColumn(treeViewer.getTree(), 0);
        nameCol.setResizable(true);
        nameCol.setWidth(10);
        return nameCol;
    }

    public static String trimIfNeccesary(String originalValue) {
        String result;
        if (originalValue != null) {
            String trimmedValue = originalValue.length() > 250 ? originalValue.substring(0, 250) + ELIPSIS_SUFFIX : originalValue;
            result = trimmedValue.replace("\n", "\\n");
        } else {
            result = "null";
        }
        return result;
    }

    public static String getQuotedString(ObjectFieldDefinition def, Boolean isUpdate) {
        String value = def.getValue();
        String ret = String.class.getCanonicalName().equals(def.getClassName()) ? DebuggerWidgetsBuilder.getQuotedString(def.getValue(), isUpdate) : value;
        return ret;
    }

    public static String getQuotedString(String value, Boolean isUpdate) {
        Object ret = value;
        if (!value.isEmpty()) {
            if (value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\"') {
                if (isUpdate.booleanValue()) {
                    value = StringEscapeUtils.escapeJava((String)value);
                }
                ret = "\"" + value + "\"";
            }
        } else {
            ret = "\"\"";
        }
        return ret;
    }

    private static void copyToClipboard(final String contentToCopy) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents((Object[])new String[]{contentToCopy}, new Transfer[]{textTransfer});
                clipboard.dispose();
            }
        });
    }

    public static class AddWatchAction
    extends ObjectFieldDefinitionAction {
        public AddWatchAction(ObjectFieldDefinition fieldDefinition) {
            super("Add watch", fieldDefinition);
            this.setEnabled(StringUtils.isNotBlank((String)this.definition.getDwAccessor()) && !MuleDebuggerMuleMessageController.isSynthetic(this.definition) && !(this.definition instanceof ExpressionFieldDefinition));
        }

        public void run() {
            AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.ADD_WATCH).addMetadata("from", "rightClick").addMetadata("script", this.definition.getDwAccessor()).track();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart view = page.findView("org.mule.tooling.ui.contribution.debugger.view");
            if (view instanceof MuleDebuggerView) {
                ((MuleDebuggerView)view).addExpressionWatch(this.definition.getDwAccessor());
            }
        }
    }

    public static class CopyDWAccessorAction
    extends ObjectFieldDefinitionAction {
        public CopyDWAccessorAction(ObjectFieldDefinition fieldDefinition) {
            super("Copy expression", fieldDefinition);
            this.setEnabled(StringUtils.isNotBlank((String)this.definition.getDwAccessor()) && !MuleDebuggerMuleMessageController.isSynthetic(this.definition));
        }

        public void run() {
            AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.COPY_EXPRESSION).addMetadata("script", this.definition.getDwAccessor()).track();
            DebuggerWidgetsBuilder.copyToClipboard(this.definition.getDwAccessor());
        }
    }

    public static class CopyValueAction
    extends ObjectFieldDefinitionAction {
        public CopyValueAction(ObjectFieldDefinition fieldDefinition) {
            super("Copy value", fieldDefinition);
            this.setEnabled(StringUtils.isNotBlank((String)this.definition.getValue()) && StringUtils.isNotBlank((String)this.definition.getDwAccessor()) && !"^mediaType".equals(this.definition.getName()) && !MuleDebuggerMuleMessageController.isSynthetic(this.definition));
        }

        public void run() {
            if (TreeNodeLabelProvider.PRIMITIVE_JDK_CLASSES_TO_BE_SHOWN.contains(this.definition.getClassName())) {
                DebuggerWidgetsBuilder.copyToClipboard(this.definition.getValue());
                AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.COPY_VALUE).addMetadata("type", this.definition.getClassName()).track();
            } else if (MuleDebuggerService.getDefault().isDebugging()) {
                MuleDebuggerService service = MuleDebuggerService.getDefault();
                service.getDebuggerClient().executeScript(this.definition.getDwAccessor(), service.getCurrentMuleMessageInfoId(), (IDebuggerResponseCallback)new CopyValueDebuggerCallback(this.definition));
            }
        }
    }

    public static class CopyValueDebuggerCallback
    extends DefaultDebuggerResponseCallback {
        private final ObjectFieldDefinition originalDefinition;

        public CopyValueDebuggerCallback(ObjectFieldDefinition originalDefinition) {
            this.originalDefinition = originalDefinition;
        }

        public void onScriptEvaluation(ScriptResultInfo info) {
            final String mimetype = info.getResultMimeType();
            if (mimetype != null && !COPY_VALUE_ACCEPTED_RAW_MIME_TYPES.contains(mimetype)) {
                String dwValueScript = String.format(COPY_VALUE_EXPRESSION_TEMPLATE, "application/dw maxCollectionSize=" + DebuggerPreferences.dwMaxCollectionSize() + ", ignoreSchema=true", this.originalDefinition.getDwAccessor());
                AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.COPY_VALUE).addMetadata("type", "script").addMetadata("script", this.originalDefinition.getDwAccessor()).track();
                MuleDebuggerService service = MuleDebuggerService.getDefault();
                service.getDebuggerClient().executeScript(dwValueScript, service.getCurrentMuleMessageInfoId(), (IDebuggerResponseCallback)new DefaultDebuggerResponseCallback(){

                    public void onScriptEvaluation(ScriptResultInfo info) {
                        String dwValue = info.getResult().getValue();
                        String clipboardToCopy = String.format(COPY_VALUE_EXPRESSION_TEMPLATE, mimetype, dwValue);
                        DebuggerWidgetsBuilder.copyToClipboard(clipboardToCopy);
                    }

                    public void onScriptEvaluationException(RemoteDebugException exception) {
                        this.handleError(exception);
                    }
                });
            } else {
                DebuggerWidgetsBuilder.copyToClipboard(this.originalDefinition.getValue());
                AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.COPY_VALUE).addMetadata("type", mimetype).track();
            }
        }

        public void onScriptEvaluationException(RemoteDebugException exception) {
            this.handleError(exception);
        }

        private void handleError(final RemoteDebugException exception) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error copying DW value", (String)("There was an error trying to evaluate the expression, error:\n" + exception.getMessage()));
                }
            });
        }
    }

    public static class FocusElementAction
    extends ObjectFieldDefinitionAction {
        public FocusElementAction(CurrentOperationFieldDefinition fieldDefinition) {
            super("Focus element", fieldDefinition);
        }

        public void run() {
            String studioPath;
            CurrentOperationFieldDefinition currentOperation = (CurrentOperationFieldDefinition)this.definition;
            String path = currentOperation.getCurrentOperationPath();
            String projectName = currentOperation.getProjectName();
            FlowEditorEntityEditPartPair pair = MuleDebuggerUtils.findEditPartAndFlowEditor(projectName, studioPath = MessageFlowUtils.mulePathToStudioPath((String)path), true);
            EntityEditPart<?> editPartFromPath = pair.getEditPart();
            if (editPartFromPath != null) {
                pair.getEditor().getFlowEditor().getViewer().reveal(editPartFromPath);
                editPartFromPath.showCollapsed();
                AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.FOCUS_ELEMENT).withOptionalConnectorProperty(Optional.ofNullable(editPartFromPath.getEntity()), MuleCorePlugin.getDesignContext().getMuleProject()).track();
            }
        }
    }

    public static class GoToClassAction
    extends ObjectFieldDefinitionAction {
        public GoToClassAction(ObjectFieldDefinition fieldDefinition) {
            super("Go to class", fieldDefinition);
        }

        public void run() {
            String className = this.definition.getClassName();
            AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.GO_TO_CLASS).addMetadata("className", className).track();
            try {
                IType file = OpenTypeAction.findTypeInWorkspace((String)className, (boolean)true);
                if (file instanceof IJavaElement) {
                    JavaUI.openInEditor((IJavaElement)file);
                } else {
                    MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)("Class : '" + className + "' can not be opened"));
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logWarning((String)"Un expected exception while trying to open a class", (Throwable)e);
            }
        }
    }

    public static abstract class ObjectFieldDefinitionAction
    extends Action {
        protected final ObjectFieldDefinition definition;

        public ObjectFieldDefinitionAction(String text, ObjectFieldDefinition fieldDefinition) {
            super(text);
            this.definition = fieldDefinition;
        }
    }

    private static final class ObjectFieldDefinitionViewerComparator
    extends ViewerComparator {
        private ObjectFieldDefinitionViewerComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result;
            TreeNode node1 = (TreeNode)e1;
            TreeNode node2 = (TreeNode)e2;
            ObjectFieldDefinition def1 = (ObjectFieldDefinition)node1.getValue();
            ObjectFieldDefinition def2 = (ObjectFieldDefinition)node2.getValue();
            if (this.isTopLevelSynthetic(def1)) {
                result = -1;
            } else if (this.isTopLevelSynthetic(def2)) {
                result = 1;
            } else if (this.isWatchExpression(def1)) {
                result = -1;
            } else if (this.isWatchExpression(def2)) {
                result = 1;
            } else {
                try {
                    Integer value1 = Integer.valueOf(def1.getName());
                    Integer value2 = Integer.valueOf(def2.getName());
                    result = value1.compareTo(value2);
                }
                catch (NumberFormatException numberFormatException) {
                    result = def1.getName().compareTo(def2.getName());
                }
            }
            return result;
        }

        private boolean isWatchExpression(ObjectFieldDefinition def) {
            return def instanceof ExpressionFieldDefinition;
        }

        private boolean isTopLevelSynthetic(ObjectFieldDefinition def) {
            return MuleDebuggerMuleMessageController.isSynthetic(def) && def.getPath().getOrderedPathElements().isEmpty();
        }
    }

    private static class TreeExpanderCollapserDoubleClickListener
    implements IDoubleClickListener {
        private TreeExpanderCollapserDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection == null || selection.isEmpty()) {
                return;
            }
            Object sel = selection.getFirstElement();
            TreeViewer treeV = (TreeViewer)event.getSource();
            ITreeContentProvider provider = (ITreeContentProvider)treeV.getContentProvider();
            if (!provider.hasChildren(sel)) {
                return;
            }
            if (treeV.getExpandedState(sel)) {
                treeV.collapseToLevel(sel, -1);
            } else {
                treeV.expandToLevel(sel, 1);
            }
        }
    }

    public static class UpdateExpressionAction
    extends ObjectFieldDefinitionAction {
        private final TreeNode treeNode;
        private final ColumnViewer viewer;

        public UpdateExpressionAction(ObjectFieldDefinition fieldDefinition, TreeNode treeNode, ColumnViewer viewer) {
            super("Update expression...", fieldDefinition);
            this.treeNode = treeNode;
            this.viewer = viewer;
        }

        public void run() {
            MuleExpressionInputDialog inputDialog = new MuleExpressionInputDialog(Display.getCurrent().getActiveShell(), "Edit Expression", "Modify the DataWeave expression to watch", this.definition.getName(), null);
            if (inputDialog.open() == 0) {
                String expression = inputDialog.getValue();
                AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.UPDATE_EXPRESSION).track();
                this.editExpressionWatch(expression);
            }
        }

        public void editExpressionWatch(String expression) {
            TreeNode[] input = (TreeNode[])this.viewer.getInput();
            TreeNode newNode = new TreeNode((Object)new ExpressionFieldDefinition(expression));
            TreeNode[] newTreeNodes = this.createNewTreeNodes(this.viewer, input, newNode, this.treeNode);
            this.viewer.setInput((Object)newTreeNodes);
            MuleDebuggerService debuggerService = MuleDebuggerService.getDefault();
            if (debuggerService.isDebugging()) {
                debuggerService.getDebuggerClient().executeScript(expression, debuggerService.getCurrentMuleMessageInfoId(), (IDebuggerResponseCallback)new ScriptEvaluationDebuggerCallback(newNode, this.viewer));
            }
        }

        private TreeNode[] createNewTreeNodes(ColumnViewer payloadTreeViewer, TreeNode[] treeNodes, TreeNode newNode, TreeNode oldNode) {
            if (treeNodes != null) {
                List collect = Stream.of(treeNodes).filter(tn -> tn != oldNode).collect(Collectors.toList());
                collect.add(newNode);
                return (TreeNode[])collect.stream().toArray(TreeNode[]::new);
            }
            return new TreeNode[]{newNode};
        }
    }

    public static class UpdateValueAction
    extends ObjectFieldDefinitionAction {
        private final TreeNode treeNode;
        private final ColumnViewer viewer;

        public UpdateValueAction(ObjectFieldDefinition fieldDefinition, TreeNode treeNode, ColumnViewer viewer) {
            super("Update value...", fieldDefinition);
            this.treeNode = treeNode;
            this.viewer = viewer;
            this.setEnabled(fieldDefinition.canEdit() && !MuleDebuggerMuleMessageController.isSynthetic(this.definition));
        }

        public void run() {
            SimpleEditorDialog dialog = WidgetUtils.createSimpleEditorDialog(UpdateExpressionEditor.class, (ISimpleDialogEditorPresenter)new UpdateExpressionController(this.definition, this.treeNode, this.viewer), (String)"Set", (String)"Close");
            dialog.setSize(350, 350);
            dialog.open();
        }
    }
}

