/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.impl;

import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.ui.contribution.debugger.controller.WatchesController;
import org.mule.tooling.ui.contribution.debugger.view.impl.MuleExpressionInputDialog;

public class AddExpressionToWatches
extends Action {
    private WatchesController watchesController;
    private Shell shell;

    public AddExpressionToWatches(Shell shell, WatchesController watchesController) {
        this.shell = shell;
        this.watchesController = watchesController;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        this.setText("Add expression to watches");
        this.setToolTipText("Add expression to watches");
    }

    public void run() {
        Display.getDefault().asyncExec(() -> {
            MuleExpressionInputDialog inputDialog = new MuleExpressionInputDialog(this.shell, "New Expression", "Insert a new DataWeave expression to watch", null, null);
            if (inputDialog.open() == 0) {
                String expression = inputDialog.getValue();
                this.watchesController.addExpressionWatch(expression);
                AnalyticsRecordsFactory.single((String)DebugEvents.ADD_WATCH, Optional.ofNullable(MuleCorePlugin.getDesignContext().getMuleProject())).addMetadata("from", "table").addMetadata("script", expression).track();
            }
        });
    }
}

