/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.actions;

import com.mulesoft.mule.debugger.client.IDebuggerClient;
import com.mulesoft.mule.debugger.response.callback.DefaultDebuggerResponseCallback;
import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerImages;

public class ToggleSchedulerAction
extends Action {
    private final SchedulerAction action;
    private String flowName;

    public ToggleSchedulerAction(SchedulerAction action) {
        this.action = action;
        this.setImageDescriptor(action.getImageDescriptor());
        this.setText(action.getLabel());
        this.setToolTipText(action.getLabel());
    }

    public ToggleSchedulerAction(SchedulerAction action, String flowName) {
        this(action);
        this.flowName = flowName;
    }

    public void run() {
        MessageFlowEditor messageFlowEditor = MessageFlowUtils.getFlowEditorFromActivePage();
        IMuleProject muleProject = messageFlowEditor.getMuleProject();
        IDebuggerClient client = MuleDebuggerService.getDefault().getDebuggerClient();
        this.action.execute(muleProject, client, this.flowName);
    }

    public static enum SchedulerAction {
        START_SCHEDULER("Start Scheduler", DebuggerImages.IMG_POLL_PLAY, (muleProject, client, flowName) -> {
            AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.TOGGLE_SCHEDULER).addMetadata("operation", "start").track();
            client.startScheduler(muleProject.getName(), flowName, flowName == null, (IDebuggerResponseCallback)new DefaultDebuggerResponseCallback(){

                public void onSchedulerStart() {
                    if (flowName == null) {
                        MuleDebuggerService.getDefault().setPolling(true);
                    } else {
                        MuleDebuggerService.getDefault().setPolling(true, flowName);
                    }
                }
            });
        }),
        STOP_SCHEDULER("Stop Scheduler", DebuggerImages.IMG_POLL_STOP, (muleProject, client, flowName) -> {
            AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.TOGGLE_SCHEDULER).addMetadata("operation", "stop").track();
            client.stopScheduler(muleProject.getName(), flowName, flowName == null, (IDebuggerResponseCallback)new DefaultDebuggerResponseCallback(){

                public void onSchedulerStop() {
                    if (flowName == null) {
                        MuleDebuggerService.getDefault().setPolling(false);
                    } else {
                        MuleDebuggerService.getDefault().setPolling(false, flowName);
                    }
                }
            });
        });

        private final String label;
        private final ImageDescriptor imgDescriptor;
        private final ActionExecutor actionExecutor;

        private SchedulerAction(String label, ImageDescriptor imgDescriptor, ActionExecutor actionExecutor) {
            this.label = label;
            this.imgDescriptor = imgDescriptor;
            this.actionExecutor = actionExecutor;
        }

        protected String getLabel() {
            return this.label;
        }

        protected ImageDescriptor getImageDescriptor() {
            return this.imgDescriptor;
        }

        public void execute(IMuleProject muleProject, IDebuggerClient client, String flowName) {
            this.actionExecutor.execute(muleProject, client, flowName);
        }

        private static interface ActionExecutor {
            public void execute(IMuleProject var1, IDebuggerClient var2, String var3);
        }
    }
}

