/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.contribution.debugger.service.BreakpointDefinition;
import org.mule.tooling.ui.contribution.debugger.service.MuleBreakpointService;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerImages;

public class ToggleBreakpointAction
extends Action {
    private static final String ADD_BREAKPOINT = "Add breakpoint";
    private static final String REMOVE_BREAKPOINT = "Remove breakpoint";

    public ToggleBreakpointAction(boolean exists) {
        String label = exists ? REMOVE_BREAKPOINT : ADD_BREAKPOINT;
        this.setToolTipText(label);
        this.setText(label);
        this.setImageDescriptor(DebuggerImages.getDebuggerImages().getImageDescriptor("icons/small/breakpoint-16x16.png"));
        this.setEnabled(true);
    }

    public void run() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IEditorPart activeEditor = activeWorkbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor instanceof MultiPageMessageFlowEditor) {
            MessageFlowEntity entity;
            MultiPageMessageFlowEditor editor = (MultiPageMessageFlowEditor)activeEditor;
            MessageFlowEditor messageFlowEditor = editor.getFlowEditor();
            List selectedEditParts = messageFlowEditor.getViewer().getSelectedEditParts();
            if (selectedEditParts.isEmpty()) {
                return;
            }
            EntityEditPart selectedEditPart = (EntityEditPart)selectedEditParts.get(0);
            MuleConfiguration muleConfig = (MuleConfiguration)messageFlowEditor.getModelRoot().getEntity();
            IMuleProject muleProject = messageFlowEditor.getMuleProject();
            MulePath path = MessageFlowUtils.findMulePathForEntity((IMuleProject)muleProject, (MuleConfiguration)muleConfig, (IMessageFlowEntity)(entity = selectedEditPart.getEntity()));
            if (path == null) {
                return;
            }
            MuleBreakpointService breakpointService = MuleDebuggerService.getDefault().getBreakpointService();
            BreakpointDefinition breakpoint = new BreakpointDefinition(muleProject.getName(), muleConfig.getName(), path.toString());
            IMessageFlowNode node = (IMessageFlowNode)selectedEditPart.getEntity();
            breakpoint.setNodeName(node.getDefinition().getName());
            breakpoint.setIconPath(node.getDefinition().getIconPath());
            if (breakpointService.containsBreakpoint(breakpoint)) {
                AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.TOGGLE_BREAKPOINT).addMetadata("operation", "remove").addMetadata("from", "canvas").withConnectorProperty(entity, muleProject).track();
                breakpointService.removeBreakpoint(breakpoint);
            } else {
                AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.TOGGLE_BREAKPOINT).addMetadata("operation", "add").addMetadata("from", "canvas").withConnectorProperty(entity, muleProject).track();
                breakpointService.addBreakpoint(breakpoint);
            }
            selectedEditPart.updateFigure();
            selectedEditPart.getFigure().repaint();
        }
    }
}

