/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.actions;

import java.util.Comparator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.mule.tooling.ui.contribution.debugger.Activator;
import org.mule.tooling.ui.contribution.debugger.service.BreakpointDefinition;
import org.mule.tooling.ui.contribution.debugger.view.impl.MuleBreakpointEditorImpl;

public class SortBreakpointsAction
extends Action {
    private MuleBreakpointEditorImpl muleBreakpointEditorImpl;
    private BreakpointComparator breakpointComparator;

    public SortBreakpointsAction(MuleBreakpointEditorImpl muleBreakpointEditorImpl, BreakpointComparator breakpointComparator) {
        this.muleBreakpointEditorImpl = muleBreakpointEditorImpl;
        this.breakpointComparator = breakpointComparator;
        this.setInitialState();
    }

    private void setInitialState() {
        this.setEnabled(true);
        this.setText(this.breakpointComparator.getLabel());
        this.setToolTipText("Sort by: " + this.breakpointComparator.getLabel());
        this.setChecked(this.isCurrentAction());
    }

    public boolean isCurrentAction() {
        return Activator.getDefault().getPreferenceStore().getInt("breakpoint.sorting.order") == this.breakpointComparator.getId();
    }

    public void run() {
        Activator.getDefault().getPreferenceStore().setValue("breakpoint.sorting.order", this.breakpointComparator.getId());
        this.muleBreakpointEditorImpl.getBreakpointTable().setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                BreakpointDefinition bp1 = (BreakpointDefinition)e1;
                BreakpointDefinition bp2 = (BreakpointDefinition)e2;
                return SortBreakpointsAction.this.breakpointComparator.getComparator().compare(bp1, bp2);
            }
        });
    }

    public static enum BreakpointComparator {
        SORT_BY_NODE(0, "Name", Comparator.comparing(BreakpointDefinition::toString)),
        SORT_BY_CREATION_TIME(1, "Creation time", Comparator.comparing(BreakpointDefinition::getCreationTime));

        private int id;
        private String label;
        private Comparator<BreakpointDefinition> comparator;

        private BreakpointComparator(int id, String label, Comparator<BreakpointDefinition> comparator) {
            this.id = id;
            this.label = label;
            this.comparator = comparator;
        }

        public int getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public Comparator<BreakpointDefinition> getComparator() {
            return this.comparator;
        }
    }
}

