/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.actions;

import java.util.List;
import java.util.Optional;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.utils.MuleDebuggerUtils;

public class RunToProcessorCommand
extends Command {
    public void execute() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IEditorPart activeEditor = activeWorkbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor instanceof MultiPageMessageFlowEditor) {
            MultiPageMessageFlowEditor editor = (MultiPageMessageFlowEditor)activeEditor;
            MessageFlowEditor messageFlowEditor = editor.getFlowEditor();
            List selectedEditParts = messageFlowEditor.getViewer().getSelectedEditParts();
            if (selectedEditParts.isEmpty()) {
                return;
            }
            EntityEditPart selectedEditPart = (EntityEditPart)selectedEditParts.get(0);
            if (!MuleDebuggerUtils.supportsDebugging(selectedEditPart.getEntity())) {
                return;
            }
            MuleConfiguration muleConfig = (MuleConfiguration)messageFlowEditor.getModelRoot().getEntity();
            MulePath path = MessageFlowUtils.findMulePathForEntity((IMuleProject)messageFlowEditor.getMuleProject(), (MuleConfiguration)muleConfig, (IMessageFlowEntity)selectedEditPart.getEntity());
            if (path == null) {
                return;
            }
            MuleDebuggerService service = MuleDebuggerService.getDefault();
            service.getDebuggerClient().runToProcessor(path.toString(), service.getCurrentMuleMessageInfoId());
            AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.RUN_TO_PROCESSOR).withOptionalConnectorProperty(Optional.ofNullable(selectedEditPart.getEntity()), messageFlowEditor.getMuleProject()).track();
        }
    }

    public boolean canUndo() {
        return false;
    }
}

