/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.actions;

import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.ui.contribution.debugger.service.BreakpointDefinition;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.utils.MuleDebuggerUtils;
import org.mule.tooling.ui.contribution.debugger.view.IMuleBreakpointEditor;

public class RemoveBreakpointAction
extends Action {
    private IMuleBreakpointEditor muleBreakpointsView;

    public RemoveBreakpointAction(IMuleBreakpointEditor muleBreakpointsView) {
        this.muleBreakpointsView = muleBreakpointsView;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE"));
        this.setToolTipText("Remove breakpoint");
        this.setText("Remove breakpoint");
        this.setEnabled(true);
    }

    public void run() {
        ISelection selection = this.muleBreakpointsView.getBreakpointTable().getSelection();
        if (!selection.isEmpty()) {
            Object[] breakpoints;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = breakpoints = structuredSelection.toArray();
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                Object bkpoint = objectArray[n2];
                BreakpointDefinition breakpointDef = (BreakpointDefinition)bkpoint;
                MuleDebuggerService.getDefault().getBreakpointService().removeBreakpoint(breakpointDef);
                EntityEditPart<?> editPart = MuleDebuggerUtils.findEditPartFromPathInOpenEditors(breakpointDef.getAppName(), breakpointDef.getPath(), false);
                if (editPart != null) {
                    AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.TOGGLE_BREAKPOINT).addMetadata("operation", "remove").addMetadata("from", "table").withOptionalConnectorProperty(Optional.ofNullable(editPart.getEntity()), MuleCorePlugin.getDesignContext().getMuleProject()).track();
                }
                ++n2;
            }
        }
    }
}

