/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerEventTypes;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerImages;
import org.mule.tooling.ui.contribution.debugger.view.impl.ScriptEvaluatePopupDialog;
import org.mule.tooling.utils.eventbus.EventBus;

public class OpenScriptEvaluatePopupAction
extends Action {
    private EventBus eventBus;

    public OpenScriptEvaluatePopupAction(EventBus eventBus) {
        this.eventBus = eventBus;
        this.setImageDescriptor(DebuggerImages.getDebuggerImages().getImageDescriptor("icons/small/expression.png"));
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        this.setTooltip(bindingService);
        this.setText("Evaluate");
        this.setEnabled(false);
        bindingService.addBindingManagerListener(event -> {
            if (event.isActiveBindingsChanged()) {
                this.setTooltip(bindingService);
            }
        });
        this.eventBus.registerListener(DebuggerEventTypes.MULE_MESSAGE_ARRIVED, (muleMessageInfo, exceptionThrown) -> this.setEnabled(true));
        this.eventBus.registerListener(DebuggerEventTypes.RESUMED, () -> this.setEnabled(false));
        this.eventBus.registerListener(DebuggerEventTypes.DISCONNECTED, () -> this.setEnabled(false));
    }

    private void setTooltip(IBindingService bindingService) {
        String keyBinding = bindingService.getBestActiveBindingFormattedFor("org.mule.tooling.debugger.commands.openevaluatepopup");
        StringBuilder stringBuilder = new StringBuilder("Evaluate DataWeave Expression");
        if (keyBinding != null) {
            stringBuilder.append(" (" + keyBinding + ")");
        }
        this.setToolTipText(stringBuilder.toString());
    }

    public void run() {
        ScriptEvaluatePopupDialog scriptEvaluatePopupDialog = ScriptEvaluatePopupDialog.getInstance();
        scriptEvaluatePopupDialog.open();
    }
}

