/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerEventTypes;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerImages;
import org.mule.tooling.utils.eventbus.EventBus;

public class NextStepAction
extends Action {
    private final EventBus eventBus;

    public NextStepAction(EventBus eventBus) {
        this.eventBus = eventBus;
        this.setImageDescriptor(DebuggerImages.IMG_NEXT_STEP);
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        this.setTooltip(bindingService);
        this.setText("Next processor");
        this.setEnabled(false);
        bindingService.addBindingManagerListener(event -> {
            if (event.isActiveBindingsChanged()) {
                this.setTooltip(bindingService);
            }
        });
        this.eventBus.registerListener(DebuggerEventTypes.MULE_MESSAGE_ARRIVED, (muleMessageInfo, exceptionThrown) -> this.setEnabled(true));
        this.eventBus.registerListener(DebuggerEventTypes.RESUMED, () -> this.setEnabled(false));
        this.eventBus.registerListener(DebuggerEventTypes.DISCONNECTED, () -> this.setEnabled(false));
    }

    public void run() {
        this.setEnabled(false);
        AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.NEXT_STEP).addMetadata("from", "menu").track();
        MuleDebuggerService service = MuleDebuggerService.getDefault();
        service.getDebuggerClient().nextStep(service.getCurrentMuleMessageInfoId());
    }

    private void setTooltip(IBindingService bindingService) {
        String keyBinding = bindingService.getBestActiveBindingFormattedFor("org.mule.tooling.debugger.commands.nextstep");
        StringBuilder stringBuilder = new StringBuilder("Next processor");
        if (keyBinding != null) {
            stringBuilder.append(" (" + keyBinding + ")");
        }
        this.setToolTipText(stringBuilder.toString());
    }
}

