/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.actions;

import org.eclipse.jface.action.Action;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.ui.contribution.debugger.service.MuleBreakpointService;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerImages;

public class MuteBreakpointsAction
extends Action {
    public MuteBreakpointsAction() {
        this.setEnabled(true);
        this.setText("Mute breakpoints");
        this.setToolTipText("Mute breakpoints");
        this.setChecked(MuleDebuggerService.getDefault().getBreakpointService().isMuteBreakpoints());
        this.setImageDescriptor(DebuggerImages.getDebuggerImages().getImageDescriptor("icons/small/breakpoint-muted-16x16.png"));
    }

    public void run() {
        MuleBreakpointService breakpointService = MuleDebuggerService.getDefault().getBreakpointService();
        Boolean muteBreakpoints = !breakpointService.isMuteBreakpoints();
        AnalyticsRecordsFactory.single((String)DebugEvents.MUTE_BREAKPOINTS).addMetadata("muted", muteBreakpoints.toString()).track();
        breakpointService.setMuteBreakpoints(muteBreakpoints);
        this.setChecked(muteBreakpoints);
    }
}

