/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.actions;

import org.eclipse.jface.action.Action;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerEventTypes;
import org.mule.tooling.ui.contribution.debugger.preferences.DebuggerPreferences;
import org.mule.tooling.ui.contribution.debugger.service.MuleBreakpointService;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerImages;

public class EnableExceptionBreakpointAction
extends Action {
    private MuleBreakpointService breakpointService = MuleDebuggerService.getDefault().getBreakpointService();

    public EnableExceptionBreakpointAction() {
        super("Error breakpoints", 8);
        boolean exceptionBreakpointEnabled = this.breakpointService.isExceptionBreakpointEnabled();
        this.updateButtonState(exceptionBreakpointEnabled);
        this.setText("Error breakpoints");
        this.setEnabled(!this.breakpointService.isMuteBreakpoints());
        this.setChecked(exceptionBreakpointEnabled);
        this.updateButtonAccordingToMuteState();
        MuleDebuggerService.getDefault().getEventBus().registerListener(DebuggerEventTypes.MUTE_BREAKPOINTS, () -> this.updateButtonAccordingToMuteState());
    }

    private void updateButtonAccordingToMuteState() {
        if (DebuggerPreferences.isMuteBreakpointsDisablesErrorBreakpoints() && this.breakpointService.isMuteBreakpoints()) {
            String imagePath = this.breakpointService.isExceptionBreakpointEnabled() ? "icons/small/exception_breakpoint_muted_16x16.png" : "icons/small/exception_breakpoint_disabled_muted_16x16.png";
            this.breakpointService.setExceptionBreakpointEnabled(false);
            this.setImageDescriptor(DebuggerImages.getDebuggerImages().getImageDescriptor(imagePath));
            this.setEnabled(!this.breakpointService.isMuteBreakpoints());
        } else if (!this.breakpointService.isMuteBreakpoints()) {
            String imagePath = this.isChecked() ? "icons/small/exception_breakpoint_16x16.png" : "icons/small/exception_breakpoint_disabled_16x16.png";
            this.breakpointService.setExceptionBreakpointEnabled(this.isChecked());
            this.setImageDescriptor(DebuggerImages.getDebuggerImages().getImageDescriptor(imagePath));
            this.setEnabled(!this.breakpointService.isMuteBreakpoints());
        }
    }

    private void updateButtonState(boolean exceptionBreakpointEnable) {
        this.setImageDescriptor(exceptionBreakpointEnable ? DebuggerImages.getDebuggerImages().getImageDescriptor("icons/small/exception_breakpoint_16x16.png") : DebuggerImages.getDebuggerImages().getImageDescriptor("icons/small/exception_breakpoint_disabled_16x16.png"));
        this.setToolTipText(exceptionBreakpointEnable ? "Disable error breakpoints" : "Enable error breakpoints");
        this.setChecked(exceptionBreakpointEnable);
    }

    public void run() {
        Boolean enabled = !this.breakpointService.isExceptionBreakpointEnabled();
        AnalyticsRecordsFactory.single((String)DebugEvents.EXCEPTION_BREAKPOINTS).addMetadata("enabled", enabled.toString()).track();
        this.breakpointService.setExceptionBreakpointEnabled(enabled);
        this.updateButtonState(this.breakpointService.isExceptionBreakpointEnabled());
    }
}

