/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.actions;

import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.contribution.debugger.service.BreakpointDefinition;
import org.mule.tooling.ui.contribution.debugger.service.MuleBreakpointService;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerImages;

public class EnableBreakpointAction
extends Action {
    private static final String DISABLE_BREAKPOINT = "Disable breakpoint";
    private static final String ENABLE_BREAKPOINT = "Enable breakpoint";

    public EnableBreakpointAction(boolean enabled) {
        if (enabled) {
            this.setToolTipText(DISABLE_BREAKPOINT);
            this.setText(DISABLE_BREAKPOINT);
        } else {
            this.setToolTipText(ENABLE_BREAKPOINT);
            this.setText(ENABLE_BREAKPOINT);
        }
        this.setImageDescriptor(DebuggerImages.getDebuggerImages().getImageDescriptor("icons/small/breakpoint-disabled-16x16.png"));
        this.setEnabled(true);
    }

    public void run() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IEditorPart activeEditor = activeWorkbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor instanceof MultiPageMessageFlowEditor) {
            BreakpointDefinition breakpoint;
            MessageFlowEntity entity;
            MultiPageMessageFlowEditor editor = (MultiPageMessageFlowEditor)activeEditor;
            MessageFlowEditor messageFlowEditor = editor.getFlowEditor();
            List selectedEditParts = messageFlowEditor.getViewer().getSelectedEditParts();
            if (selectedEditParts.isEmpty()) {
                return;
            }
            EntityEditPart selectedEditPart = (EntityEditPart)selectedEditParts.get(0);
            MuleConfiguration muleConfig = (MuleConfiguration)messageFlowEditor.getModelRoot().getEntity();
            IMuleProject muleProject = messageFlowEditor.getMuleProject();
            MulePath path = MessageFlowUtils.findMulePathForEntity((IMuleProject)muleProject, (MuleConfiguration)muleConfig, (IMessageFlowEntity)(entity = selectedEditPart.getEntity()));
            if (path == null) {
                return;
            }
            MuleBreakpointService breakpointService = MuleDebuggerService.getDefault().getBreakpointService();
            breakpoint.setEnabled(!(breakpoint = breakpointService.findBreakpoint(new BreakpointDefinition(muleProject.getName(), muleConfig.getName(), path.toString()))).isEnabled());
            if (!breakpointService.isMuteBreakpoints()) {
                if (breakpoint.isEnabled()) {
                    AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.TOGGLE_BREAKPOINT).addMetadata("operation", "enable").addMetadata("from", "canvas").withOptionalConnectorProperty(Optional.ofNullable(entity), MuleCorePlugin.getDesignContext().getMuleProject()).track();
                    MuleDebuggerService.getDefault().getBreakpointService().enableBreakpoint(breakpoint);
                } else {
                    AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.TOGGLE_BREAKPOINT).addMetadata("operation", "disable").addMetadata("from", "canvas").withOptionalConnectorProperty(Optional.ofNullable(entity), MuleCorePlugin.getDesignContext().getMuleProject()).track();
                    MuleDebuggerService.getDefault().getBreakpointService().disableBreakpoint(breakpoint);
                }
            }
        }
    }
}

