/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.actions;

import java.util.Optional;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.messageflow.editor.IMessageFlowNodeContextMenuProvider;
import org.mule.tooling.messageflow.util.MessageFlowEntityRef;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.ui.contribution.debugger.service.BreakpointDefinition;
import org.mule.tooling.ui.contribution.debugger.service.MuleBreakpointService;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.utils.MuleDebuggerUtils;
import org.mule.tooling.ui.contribution.debugger.view.actions.EnableBreakpointAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.ToggleBreakpointAction;
import org.mule.tooling.ui.contribution.debugger.view.actions.ToggleSchedulerAction;

public class DebuggerNodeContextMenuProvider
implements IMessageFlowNodeContextMenuProvider {
    public void addActionsForNode(IMenuManager menu, MessageFlowNode selected) {
        if (MuleDebuggerUtils.supportsDebugging((MessageFlowEntity)selected)) {
            Optional<BreakpointDefinition> breakpoint = this.findBreakpointFromSelected(selected);
            menu.add((IAction)new ToggleBreakpointAction(breakpoint.isPresent()));
            if (breakpoint.isPresent()) {
                menu.add((IAction)new EnableBreakpointAction(breakpoint.get().isEnabled()));
            }
        }
        if (ModelUtils.isScheduler((IMessageFlowEntity)selected)) {
            MessageFlowEntityRef entityRef = MessageFlowUtils.findMulePathForEntityInOpenEditors((IMessageFlowEntity)selected);
            ToggleSchedulerAction startSchedulerAction = new ToggleSchedulerAction(ToggleSchedulerAction.SchedulerAction.START_SCHEDULER, entityRef.getMulePath().getFlowName());
            ToggleSchedulerAction stopSchedulerAction = new ToggleSchedulerAction(ToggleSchedulerAction.SchedulerAction.STOP_SCHEDULER, entityRef.getMulePath().getFlowName());
            boolean isDebugging = MuleDebuggerService.getDefault().isDebugging();
            boolean isPolling = MuleDebuggerService.getDefault().isPolling(entityRef.getMulePath().getFlowName());
            startSchedulerAction.setEnabled(isDebugging && !isPolling);
            stopSchedulerAction.setEnabled(isDebugging && isPolling);
            menu.add((IAction)startSchedulerAction);
            menu.add((IAction)stopSchedulerAction);
        }
    }

    private Optional<BreakpointDefinition> findBreakpointFromSelected(MessageFlowNode selected) {
        MuleBreakpointService breakpointService = MuleDebuggerService.getDefault().getBreakpointService();
        MessageFlowEntityRef entityRef = MessageFlowUtils.findMulePathForEntityInOpenEditors((IMessageFlowEntity)selected);
        return Optional.ofNullable(breakpointService.findBreakpointFromAppConfigAndPath(entityRef.getMuleProject().getName(), entityRef.getMuleConfiguration().getName(), entityRef.getMulePath().toPath()));
    }
}

