/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.actions;

import com.mulesoft.mule.debugger.client.IDebuggerClient;
import com.mulesoft.mule.debugger.client.impl.DebuggerClientFactory;
import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerEventTypes;
import org.mule.tooling.ui.contribution.debugger.controller.events.ClientInitializedEvent;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerConnectedHandler;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerDisconnectedHandler;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerImages;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class ConnectAction
extends Action {
    private static final String ENABLE_DEBUGGER_CONNECTION_ACTIONS = "studio.enableDebuggerConnectionActions";
    private IDebuggerClient client;
    private final EventBus bus;
    private final IDebuggerResponseCallback callback;
    private static String DEFAULT_HOST = "localhost";
    private static int DEFAULT_PORT = 6666;
    private int port;
    private String host;

    public ConnectAction(EventBus bus, IDebuggerResponseCallback callback, int port, String host) {
        this.bus = bus;
        this.callback = callback;
        this.port = port;
        this.host = host;
        this.setConnectState();
        this.bus.registerListener(DebuggerEventTypes.CONNECTED, (IEventHandler)new IDebuggerConnectedHandler(){

            @Override
            public void onConnected() {
                ConnectAction.this.setDisconnectState();
                MuleDebuggerService.getDefault().setDebugging(true);
            }
        });
        this.bus.registerListener(DebuggerEventTypes.DISCONNECTED, (IEventHandler)new IDebuggerDisconnectedHandler(){

            @Override
            public void onDisconnected() {
                ConnectAction.this.setConnectState();
                MuleDebuggerService.getDefault().setDebugging(false);
            }
        });
    }

    public ConnectAction(EventBus bus, IDebuggerResponseCallback callback) {
        this(bus, callback, DEFAULT_PORT, DEFAULT_HOST);
    }

    protected void setConnectState() {
        this.setImageDescriptor(DebuggerImages.IMG_DISCONNECT);
        this.setToolTipText("Connect");
        this.setText("Connect");
        this.setEnabled(true);
    }

    protected void setDisconnectState() {
        this.setImageDescriptor(DebuggerImages.IMG_CONNECT);
        this.setToolTipText("Disconnect");
        this.setText("Disconnect");
        this.setEnabled(true);
    }

    public void run() {
        if (this.client == null) {
            boolean doConnect = false;
            int retry = 0;
            this.client = DebuggerClientFactory.create((String)this.getHost(), (int)this.getPort());
            while (!doConnect && retry < 60) {
                if (!MuleDebuggerService.getDefault().isDebugging() && !System.getProperties().containsKey(ENABLE_DEBUGGER_CONNECTION_ACTIONS)) {
                    return;
                }
                doConnect = this.doConnect();
                ++retry;
                if (doConnect) continue;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!doConnect) {
                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Mule Debugger", (String)MessageFormat.format("Studio is not able to connect to Debugger server.\nCheck:\n\u2022Your firewall or antivirus is not blocking the port: {0}\n\u2022There is not other system process runing on port: {0} ", String.valueOf(this.port), String.valueOf(this.port))));
            }
        } else {
            this.client.exit();
            this.client = null;
        }
    }

    public boolean doConnect() {
        try {
            System.out.println("Trying to connect");
            this.client.start(this.callback);
            this.bus.fireEvent((IEvent)new ClientInitializedEvent(this.client));
            this.setEnabled(false);
        }
        catch (IOException iOException) {
            System.out.println("Connection failed");
            return false;
        }
        System.out.println("Connection succesful");
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

