/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.utils;

import java.util.concurrent.Callable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleRoot;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.contribution.debugger.Activator;
import org.mule.tooling.ui.contribution.debugger.utils.FlowEditorEntityEditPartPair;
import org.mule.tooling.utils.Pair;
import org.mule.tooling.utils.exception.IllegalCreationException;

public class MuleDebuggerUtils {
    private MuleDebuggerUtils() {
        throw new IllegalCreationException();
    }

    public static boolean supportsDebugging(MessageFlowEntity entity) {
        return !ModelUtils.isMessageSource((IMessageFlowEntity)entity) && !ModelUtils.isFlowOrSubflow((IMessageFlowEntity)entity) && !MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)entity) && !ModelUtils.isComment((IMessageFlowEntity)entity);
    }

    public static EntityEditPart<?> findEditPartFromPathInOpenEditors(String projectName, String path, boolean switchToFlowEditorPage) {
        FlowEditorEntityEditPartPair pair = MuleDebuggerUtils.findEditPartAndFlowEditorInOpenEditors(projectName, path, switchToFlowEditorPage);
        return pair.getEditPart();
    }

    public static FlowEditorEntityEditPartPair findEditPartAndFlowEditorInOpenEditors(String projectName, String path, boolean switchToFlowEditorPage) {
        IEditorReference[] editorReferences;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return new FlowEditorEntityEditPartPair(null, null);
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorRef = iEditorReferenceArray[n2];
            IWorkbenchPart part = iEditorRef.getPart(true);
            if (part instanceof MultiPageMessageFlowEditor) {
                MultiPageMessageFlowEditor editorPart = (MultiPageMessageFlowEditor)part;
                if (projectName == null || editorPart.getFilePath().split("/")[1].equals(projectName)) {
                    IEditorPart originalActivePage = null;
                    boolean switchedEditorPage = false;
                    if (switchToFlowEditorPage && editorPart.getCurentPageIndex() != editorPart.getFlowEditorIndex()) {
                        originalActivePage = editorPart.getActiveEditor();
                        editorPart.openFlowEditorPage();
                        switchedEditorPage = true;
                    }
                    MessageFlowEditor flowEditor = editorPart.getFlowEditor();
                    MessageFlowEntity entityForMulePath = MessageFlowUtils.findEntityForMulePathInOpenEditors((String)path, (String)projectName);
                    EntityEditPart editPart = MessageFlowEditor.findEditPartInRegistry((EditPartViewer)flowEditor.getViewer(), (IMessageFlowEntity)entityForMulePath);
                    if (editPart != null) {
                        return new FlowEditorEntityEditPartPair(editPart, editorPart);
                    }
                    if (switchedEditorPage) {
                        editorPart.setActiveEditor(originalActivePage);
                    }
                }
            }
            ++n2;
        }
        return new FlowEditorEntityEditPartPair(null, null);
    }

    public static FlowEditorEntityEditPartPair findEditPartAndFlowEditor(String projectName, final String path, boolean switchToFlowEditorPage) {
        final IMuleProject muleProject = MuleDebuggerUtils.getMuleProjectWithName(projectName);
        StudioDesignContextRunner.runSilentWithMuleProject((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MuleDebuggerUtils.openConfigForPath(path, muleProject);
                return null;
            }
        }, (IMuleProject)muleProject);
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return new FlowEditorEntityEditPartPair(null, null);
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor instanceof MultiPageMessageFlowEditor) {
            MessageFlowEditor flowEditor;
            MultiPageMessageFlowEditor editorPart = (MultiPageMessageFlowEditor)activeEditor;
            IEditorPart originalActivePage = null;
            boolean switchedEditorPage = false;
            if (switchToFlowEditorPage && editorPart.getCurentPageIndex() != editorPart.getFlowEditorIndex()) {
                originalActivePage = editorPart.getActiveEditor();
                editorPart.openFlowEditorPage();
                switchedEditorPage = true;
            }
            if ((flowEditor = editorPart.getFlowEditor()) != null) {
                MessageFlowEntity entityForMulePath = MessageFlowUtils.findEntityForMulePathInOpenEditors((String)path, (String)projectName);
                EntityEditPart editPart = MessageFlowEditor.findEditPartInRegistry((EditPartViewer)flowEditor.getViewer(), (IMessageFlowEntity)entityForMulePath);
                if (editPart != null) {
                    return new FlowEditorEntityEditPartPair(editPart, editorPart);
                }
            }
            if (switchedEditorPage) {
                editorPart.setActiveEditor(originalActivePage);
            }
        }
        return new FlowEditorEntityEditPartPair(null, null);
    }

    public static IMuleProject getMuleProjectWithName(String projectName) {
        try {
            IMuleRoot muleRoot = MuleRuntime.getMuleRoot();
            IMuleProject[] muleProjects = muleRoot.getMuleProjects();
            if (muleProjects != null) {
                IMuleProject[] iMuleProjectArray = muleProjects;
                int n = muleProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IMuleProject muleProject = iMuleProjectArray[n2];
                    if (muleProject.getName().equals(projectName)) {
                        return muleProject;
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void openConfigForPath(String path, IMuleProject muleProject) {
        if (muleProject == null) {
            return;
        }
        MulePath fromPath = MulePath.fromPath((String)path);
        Pair configuration = muleProject.getConfigurationsCache().searchMuleFlowByName(fromPath.getFlowName());
        if (configuration != null && configuration.getLeft() != null) {
            MuleDebuggerUtils.openConfigWithConfigName(muleProject, (MuleConfiguration)configuration.getLeft());
        }
    }

    private static void openConfigWithConfigName(IMuleProject muleProject, MuleConfiguration toFind) {
        try {
            for (MuleConfiguration muleConfig : muleProject.getConfigurationsCache().getConfigurations()) {
                if (!muleConfig.equals(toFind)) continue;
                MuleDebuggerUtils.openEditor(muleProject.getConfigurationsCache().getConfigurationFile(muleConfig));
                return;
            }
            throw new RuntimeException("Couldn't find a config file that matches the name " + String.valueOf(toFind));
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private static void openEditor(IFile fileToOpen) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)fileToOpen);
        }
        catch (PartInitException partInitException) {}
    }

    private static void openPerspective(String perspectiveID) {
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        try {
            PlatformUI.getWorkbench().showPerspective(perspectiveID, window);
        }
        catch (WorkbenchException workbenchException) {
            System.out.println("ERROR! Unable to open Perspective");
            MessageDialog.openError((Shell)window.getShell(), (String)"Error Opening Perspective", (String)("Could not open Perspective with ID: " + perspectiveID));
        }
    }

    private static MessageDialogWithToggle openPespectiveSwitchDialog(IWorkbenchWindow window, IPreferenceStore preferenceStore) {
        return MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)"Confirm Perspective Switch", (String)"This Mule Debug perspective is designed to support mule applications debugging. It incorporates views for displaying the current mule messages and for breakpoint management. \n\nDo you want to open this perspective now?", (String)"Remember my decision", (boolean)false, (IPreferenceStore)preferenceStore, (String)"switch.to.debug.perspective");
    }

    private static boolean isDebugPerspective(IPerspectiveDescriptor currentPerspective) {
        return currentPerspective.getId().equals("org.mule.tooling.ui.debugPerspective");
    }

    public static void openMuleDebugPerspective() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String doSwitchPref = preferenceStore.getString("switch.to.debug.perspective");
        if (!MuleDebuggerUtils.isDebugPerspective(page.getPerspective())) {
            if ("always".equals(doSwitchPref)) {
                MuleDebuggerUtils.openPerspective("org.mule.tooling.ui.debugPerspective");
            } else if (!"never".equals(doSwitchPref)) {
                MessageDialogWithToggle dialog = MuleDebuggerUtils.openPespectiveSwitchDialog(window, preferenceStore);
                if (!dialog.getToggleState()) {
                    preferenceStore.setValue("switch.to.debug.perspective", "prompt");
                }
                if (dialog.getReturnCode() == 2) {
                    MuleDebuggerUtils.openPerspective("org.mule.tooling.ui.debugPerspective");
                }
            }
        }
    }
}

