/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.service;

import com.mulesoft.mule.debugger.client.IDebuggerClient;
import com.mulesoft.mule.debugger.dto.MuleMessageInfoId;
import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.events.RefreshRequestedEvent;
import org.mule.tooling.messageflow.util.IMuleFlowProvider;
import org.mule.tooling.messageflow.util.MuleFlowProviderImpl;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.runtime.launch.LaunchesListenerAdapter;
import org.mule.tooling.runtime.launch.RuntimeUtils;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerEventTypes;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerResponseCallback;
import org.mule.tooling.ui.contribution.debugger.controller.events.LaunchedDebuggerEvent;
import org.mule.tooling.ui.contribution.debugger.service.ExpressionWatchesService;
import org.mule.tooling.ui.contribution.debugger.service.MuleBreakpointService;
import org.mule.tooling.ui.contribution.debugger.utils.MuleDebuggerUtils;
import org.mule.tooling.ui.contribution.debugger.view.actions.ConnectAction;
import org.mule.tooling.ui.contribution.debugger.view.impl.MuleDebuggerView;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class MuleDebuggerService {
    private EventBus debuggerEventBus;
    private MuleBreakpointService breakpointService;
    private IDebuggerClient debuggerClient;
    private ExpressionWatchesService expressionWatchesService;
    private boolean debugging = false;
    private ILaunch currentLaunch;
    private MuleMessageInfoId currentMuleMessageInfoId;
    private boolean polling;
    private Map<String, Boolean> pollingState;

    public static MuleDebuggerService getDefault() {
        return Singleton.instance;
    }

    public String getMuleDebuggerVersion() {
        return IDebuggerClient.class.getPackage().getImplementationVersion();
    }

    private MuleDebuggerService() {
        this.start();
    }

    private void start() {
        this.debuggerEventBus = new EventBus();
        this.breakpointService = new MuleBreakpointService(this.debuggerEventBus);
        this.expressionWatchesService = new ExpressionWatchesService();
        this.pollingState = new HashMap<String, Boolean>();
        this.polling = true;
        this.debuggerEventBus.registerListener(DebuggerEventTypes.CONNECTED, () -> Display.getDefault().asyncExec(() -> {
            this.showDebuggerView();
            MuleDebuggerUtils.openMuleDebugPerspective();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IViewReference[] viewReferences = page.getViewReferences();
            MuleDebuggerView debuggerView = null;
            IViewReference[] iViewReferenceArray = viewReferences;
            int n = viewReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewReference = iViewReferenceArray[n2];
                if (viewReference.getId().equals("org.mule.tooling.ui.contribution.debugger.view")) {
                    debuggerView = (MuleDebuggerView)viewReference.getView(true);
                    break;
                }
                ++n2;
            }
            if (debuggerView != null) {
                debuggerView.setDebuggerConnected(true);
            }
        }));
        this.debuggerEventBus.registerListener(DebuggerEventTypes.MULE_MESSAGE_ARRIVED, (muleMessageInfo, exceptionThrown) -> {
            this.setCurrentMuleMessageInfoId(muleMessageInfo.getMuleMessageInfoId());
            Display.getDefault().syncExec(() -> {
                this.showDebuggerView();
                MuleDebuggerUtils.openMuleDebugPerspective();
            });
        });
        this.debuggerEventBus.registerListener(DebuggerEventTypes.CLIENT_INITIALIZED, client -> {
            this.debuggerClient = client;
        });
        this.debuggerEventBus.registerListener(DebuggerEventTypes.DISCONNECTED, () -> {
            this.setDebugging(false);
            if (this.debuggerClient != null) {
                this.debuggerClient.disconnect();
                this.debuggerClient = null;
            }
            this.pollingState.clear();
            this.polling = true;
        });
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)new LaunchesListenerAdapter(){

            public void launchesChanged(ILaunch[] launches) {
                if (launches.length != 1) {
                    return;
                }
                ILaunch iLaunch = launches[0];
                MuleDebuggerService.this.connect(iLaunch);
            }

            public void launchesTerminated(ILaunch[] launches) {
                if (MuleDebuggerService.this.debuggerClient != null) {
                    MuleDebuggerService.this.debuggerClient.exit();
                }
                MuleDebuggerService.this.setDebugging(false);
            }
        });
    }

    private void setCurrentMuleMessageInfoId(MuleMessageInfoId muleMessageInfoId) {
        this.currentMuleMessageInfoId = muleMessageInfoId;
    }

    public MuleMessageInfoId getCurrentMuleMessageInfoId() {
        return this.currentMuleMessageInfoId;
    }

    public void connect(final ILaunch iLaunch) {
        if (RuntimeUtils.isMuleLaunch((ILaunch)iLaunch) && "debug".equals(iLaunch.getLaunchMode()) && !this.isDebugging()) {
            try {
                boolean isRemote = iLaunch.getLaunchConfiguration().getAttribute("mule-remote-debug", false);
                boolean projectsMissing = this.checkSelectedProjectsMissing(iLaunch.getLaunchConfiguration());
                if (projectsMissing && !isRemote) {
                    throw new CoreException(MuleCorePlugin.createStatus((int)4, (String)"Project referenced by launch does not exist.", null));
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            new Thread("DebuggerConnector"){

                @Override
                public void run() {
                    try {
                        String host = iLaunch.getLaunchConfiguration().getAttribute("remote-debug-host", "localhost");
                        int port = iLaunch.getLaunchConfiguration().getAttribute("remote-debug-port", 6666);
                        new ConnectAction(MuleDebuggerService.this.debuggerEventBus, (IDebuggerResponseCallback)new DebuggerResponseCallback(MuleDebuggerService.this.debuggerEventBus), port, host).run();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            this.setDebugging(true);
            this.currentLaunch = iLaunch;
        }
    }

    private boolean checkSelectedProjectsMissing(ILaunchConfiguration launchConfiguration) {
        return RuntimeUtils.getAllProjectsFromConfig((ILaunchConfiguration)launchConfiguration).isEmpty();
    }

    public void terminateCurrentLaunch() {
        if (this.currentLaunch != null && !this.currentLaunch.isTerminated() && this.currentLaunch.canTerminate()) {
            try {
                this.currentLaunch.terminate();
                this.currentLaunch = null;
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
        }
    }

    protected void showDebuggerView() {
        Display.getDefault().asyncExec(() -> {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.showView("org.mule.tooling.ui.contribution.debugger.view", null, 2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public EventBus getEventBus() {
        return this.debuggerEventBus;
    }

    public MuleBreakpointService getBreakpointService() {
        return this.breakpointService;
    }

    public ExpressionWatchesService getExpressionWacthesService() {
        return this.expressionWatchesService;
    }

    public IDebuggerClient getDebuggerClient() {
        return this.debuggerClient;
    }

    public IMuleFlowProvider getMuleFlowProvider(IMuleProject muleProject) {
        return new MuleFlowFastInitProviderImpl(muleProject, null);
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean debugging) {
        boolean changed = this.debugging ^ debugging;
        if (changed) {
            this.debugging = debugging;
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new RefreshRequestedEvent(null));
        }
        if (debugging) {
            this.getEventBus().fireEvent((IEvent)new LaunchedDebuggerEvent());
        }
    }

    public void setPolling(boolean polling) {
        this.polling = polling;
        this.pollingState.forEach((name, state) -> this.setPolling(polling, (String)name));
    }

    public boolean isPolling() {
        return this.polling;
    }

    public void setPolling(boolean polling, String flowName) {
        this.pollingState.put(flowName, polling);
    }

    public boolean isPolling(String flowName) {
        return this.pollingState.getOrDefault(flowName, this.polling);
    }

    private class MuleFlowFastInitProviderImpl
    extends MuleFlowProviderImpl {
        public MuleFlowFastInitProviderImpl(IMuleProject project, MuleConfiguration currentConfiguration) {
            super(project, currentConfiguration);
            this.initFlowsIfNecessary();
        }
    }

    private static class Singleton {
        private static final MuleDebuggerService instance = new MuleDebuggerService();

        private Singleton() {
        }
    }
}

