/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.service;

import com.google.common.collect.Sets;
import com.mulesoft.mule.debugger.client.IDebuggerClient;
import com.mulesoft.mule.debugger.dto.Breakpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMessageFlowEntityDeletedEventListener;
import org.mule.tooling.core.event.IMessageFlowEntityEditedListener;
import org.mule.tooling.core.event.IMessageFlowEntityMovedListener;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.event.IUpdateMuleFlowFromSourceListener;
import org.mule.tooling.core.event.MessageFlowEventTypes;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.events.EditPartEventTypes;
import org.mule.tooling.messageflow.events.ICommentToggledOnCanvasListener;
import org.mule.tooling.messageflow.events.INewElementCreatedOnCanvasListener;
import org.mule.tooling.messageflow.util.MessageFlowEntityRef;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.messageflow.path.MulePathNode;
import org.mule.tooling.ui.contribution.debugger.Activator;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerEventTypes;
import org.mule.tooling.ui.contribution.debugger.controller.events.IClientInitializedHandler;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerConnectedHandler;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerDisconnectedHandler;
import org.mule.tooling.ui.contribution.debugger.controller.events.MuteBreakpointsEvent;
import org.mule.tooling.ui.contribution.debugger.service.BreakpointDefinition;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.utils.MuleDebuggerUtils;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MuleBreakpointService
extends Observable {
    public static final String MULE_BREAKPOINT_MARKER = "org.mule.tooling.ui.contribution.debugger.muleBreakpointMarker";
    public static final String BREAKPOINT_PATH = "path";
    public static final String BREAKPOINT_ENABLED = "enabled";
    public static final String BREAKPOINT_APP_NAME = "appName";
    public static final String BREAKPOINT_CONFIG_NAME = "configName";
    public static final String BREAKPOINT_IS_CONDITIONAL = "conditional";
    public static final String BREAKPOINT_CONDITION = "condition";
    public static final String BREAKPOINT_NODE_NAME = "nodeName";
    public static final String BREAKPOINT_ICON_PATH = "iconPath";
    public static final String BREAKPOINT_CREATION_TIME = "creationTime";
    private EventBus debuggerEventBus;
    private Set<BreakpointDefinition> breakpoints;
    private Map<BreakpointDefinition, IMarker> breakpointMarkerForDefsMap;
    protected IDebuggerClient debuggerClient;
    private boolean muteBreakpoints = false;
    private BreakpointDefinitionObserver breakpointDefObserver;
    private boolean alreadyLoadedPersistedMarkers = false;

    public MuleBreakpointService(EventBus debuggerEventBus) {
        this.debuggerEventBus = debuggerEventBus;
        this.breakpoints = Sets.newConcurrentHashSet();
        this.breakpointMarkerForDefsMap = new HashMap<BreakpointDefinition, IMarker>();
        this.debuggerEventBus.registerListener(DebuggerEventTypes.CLIENT_INITIALIZED, (IEventHandler)new IClientInitializedHandler(){

            @Override
            public void onClientInitialized(IDebuggerClient client) {
                MuleBreakpointService.this.debuggerClient = client;
            }
        });
        this.debuggerEventBus.registerListener(DebuggerEventTypes.CONNECTED, (IEventHandler)new IDebuggerConnectedHandler(){

            @Override
            public void onConnected() {
                ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
                for (BreakpointDefinition breakpointDef : MuleBreakpointService.this.getBreakpoints()) {
                    if (!breakpointDef.isEnabled()) continue;
                    breakpoints.add(breakpointDef.toBreakpoint());
                }
                if (!MuleBreakpointService.this.isMuteBreakpoints()) {
                    MuleBreakpointService.this.debuggerClient.addBreakpoints(breakpoints.toArray(new Breakpoint[breakpoints.size()]));
                }
                MuleBreakpointService.this.debuggerClient.enableExceptionBreakpoint(MuleBreakpointService.this.isExceptionBreakpointEnabled());
            }
        });
        this.debuggerEventBus.registerListener(DebuggerEventTypes.DISCONNECTED, (IEventHandler)new IDebuggerDisconnectedHandler(){

            @Override
            public void onDisconnected() {
                MuleBreakpointService.this.debuggerClient = null;
            }
        });
        this.breakpointDefObserver = new BreakpointDefinitionObserver();
        UtilsPlugin.getEventBus().registerListener(EditPartEventTypes.ON_ELEMENT_CREATED_ON_CANVAS, (IEventHandler)new INewElementCreatedOnCanvasListener(){

            public void onCreatedNewElementOnCanvas(IMuleProject project, IMessageFlowEntity createdEntity) {
                MuleBreakpointService.this.moveBreakpointsOnCreation(project, createdEntity);
            }
        });
        MuleCorePlugin.getEventBus().registerListener(MessageFlowEventTypes.ON_MESSAGE_FLOW_ENTITY_MOVED, (IEventHandler)new IMessageFlowEntityMovedListener(){

            public void onMessageFlowEntityMoved(IMuleProject muleProject, MuleConfiguration muleConfig, IMessageFlowEntity entity, MulePath oldPath) {
                if (MuleBreakpointService.this.breakpoints.size() > 0 && !ModelUtils.isFlow((IMessageFlowEntity)entity) && !ModelUtils.isGlobalElement((IMessageFlowEntity)entity)) {
                    MulePath path = muleConfig.getPathFor(entity, muleProject);
                    if (oldPath != null) {
                        List<BreakpointDefinition> oldBreakpoints = MuleBreakpointService.this.getBreakpointsFromPath(oldPath);
                        MuleBreakpointService.this.removeBreakpoints(oldBreakpoints);
                        if (path != null) {
                            MuleBreakpointService.this.updateFromTo(oldPath, path, muleConfig);
                            MuleBreakpointService.this.replaceRelativeParent(muleProject, muleConfig, oldBreakpoints, oldPath, path);
                            EntityEditPart<?> editPart = MuleDebuggerUtils.findEditPartFromPathInOpenEditors(muleProject.getName(), oldPath.toPath(), false);
                            if (editPart != null) {
                                editPart.updateFigure();
                            }
                            MuleBreakpointService.this.updateBreakpointFigures();
                        }
                    }
                }
            }
        });
        MuleCorePlugin.getEventBus().registerListener(MessageFlowEventTypes.ON_MESSAGE_FLOW_ENTITY_DELETED, (IEventHandler)new IMessageFlowEntityDeletedEventListener(){

            public void onNodeDeleted(IMuleProject muleProject, IFile configFile, MuleConfiguration muleConfig, IMessageFlowEntity node) {
                MuleBreakpointService.this.moveBreakpointsOnDeletion(muleProject, muleConfig, node);
            }
        });
        MuleCorePlugin.getEventBus().registerListener(EditPartEventTypes.ON_COMMENT_TOGGLED_FOR_ELEMENT_ON_CANVAS, (IEventHandler)new ICommentToggledOnCanvasListener(){

            public void onCommentToggledOnCanvas(boolean isCommented, IMuleProject muleProject, IFile configFile, MuleConfiguration muleConfig, IMessageFlowEntity node) {
                if (isCommented) {
                    MuleBreakpointService.this.moveBreakpointsOnDeletion(muleProject, muleConfig, node);
                } else {
                    MuleBreakpointService.this.moveBreakpointsOnCreation(muleProject, node);
                }
            }
        });
        MuleCorePlugin.getEventBus().registerListener(CoreEventTypes.ON_FLOW_UPDATED_FROM_SOURCE, (IEventHandler)new IUpdateMuleFlowFromSourceListener(){

            public void onFlowUpdatedFromSource() {
                MuleBreakpointService.this.updateBreakpoints();
            }
        });
        MuleCorePlugin.getEventBus().registerListener(CoreEventTypes.ResourceEvents.ON_MULE_PROJECT_EVENT, (IEventHandler)new IMuleProjectEventListener(){

            public void onMuleProjectOpened(IProject project) {
                Display.getDefault().asyncExec(() -> {
                    for (BreakpointDefinition breakpoint : MuleBreakpointService.this.findBreakpointsFromMarkersWithProjectName(project.getName())) {
                        MuleBreakpointService.this.doAddBreakpoint(breakpoint);
                    }
                });
            }

            public void onMuleProjectPreClose(IMuleProject project) {
                Display.getDefault().asyncExec(() -> {
                    for (BreakpointDefinition breakpoint : MuleBreakpointService.this.findBreakpointsFromProject(project.getName())) {
                        MuleBreakpointService.this.doRemoveBreakpoint(breakpoint);
                    }
                });
            }

            public void onMuleProjectPreDelete(IMuleProject project) {
                Display.getDefault().asyncExec(() -> {
                    for (BreakpointDefinition breakpoint : MuleBreakpointService.this.findBreakpointsFromMarkersWithProjectName(project.getName())) {
                        MuleBreakpointService.this.deleteMarker(breakpoint);
                    }
                });
            }

            public void onMuleProjectClosed(IProject project) {
            }
        });
        MuleCorePlugin.getEventBus().registerListener(MessageFlowEventTypes.ON_MESSAGE_FLOW_ENTITY_EDITED, (IEventHandler)new IMessageFlowEntityEditedListener(){

            public void onMessageFlowEntityEdited(IMuleProject project, MessageFlowEntity entity, IReadOnlyPropertyCollection previousProperties) {
                if (MuleBreakpointService.this.breakpoints.size() > 0 && ModelUtils.isFlow((IMessageFlowEntity)entity)) {
                    String oldName = ((IReadOnlyProperty)previousProperties.getProperty("name")).getValue();
                    String newName = ((Container)entity).getName();
                    Collection<BreakpointDefinition> breakpoints = MuleBreakpointService.this.findBreakpointsFromProject(project.getName());
                    MuleBreakpointService.this.onFlowRenamed(breakpoints.stream().filter(bp -> oldName.equals(bp.getFlowName())).collect(Collectors.toList()), oldName, newName);
                }
            }
        });
    }

    private void moveBreakpointsOnCreation(IMuleProject project, IMessageFlowEntity createdEntity) {
        MulePath mulePath;
        MessageFlowEntityRef entityRef;
        if (this.breakpoints.size() > 0 && (entityRef = MessageFlowUtils.findMulePathForEntityInOpenEditors((IMessageFlowEntity)createdEntity)) != null && (mulePath = entityRef.getMulePath()) != null && !mulePath.getNodes().isEmpty()) {
            this.updateLevel(mulePath, true, entityRef.getMuleConfiguration());
            String projectName = project.getName();
            EntityEditPart<?> editPart = MuleDebuggerUtils.findEditPartFromPathInOpenEditors(projectName, mulePath.toPath(), false);
            if (editPart != null) {
                editPart.updateFigure();
            }
            this.updateBreakpointFigures();
        }
    }

    private void moveBreakpointsOnDeletion(IMuleProject muleProject, MuleConfiguration muleConfig, IMessageFlowEntity node) {
        MulePath path = MessageFlowUtils.findMulePathForEntity((IMuleProject)muleProject, (MuleConfiguration)muleConfig, (IMessageFlowEntity)node);
        if (path != null && !ModelUtils.isGlobalElement((IMessageFlowEntity)node)) {
            this.removeBreakpoints(this.getBreakpointsFromPath(path));
            this.updateLevel(path, false, muleConfig);
        } else if (node instanceof Container) {
            String flowName = ((Container)node).getName();
            List<BreakpointDefinition> flowBreakpoints = this.filterBreakpoints(flowName, this.findBreakpointsFromProject(muleProject.getName()));
            this.removeBreakpoints(flowBreakpoints);
        }
    }

    private List<BreakpointDefinition> filterBreakpoints(String flowNameFilter, Collection<BreakpointDefinition> breakpoints) {
        return breakpoints.stream().filter(breakpoint -> flowNameFilter.equals(breakpoint.getFlowName())).collect(Collectors.toList());
    }

    private boolean shouldUpdateRouteLevel(MulePath path, MuleConfiguration muleConfig) {
        List nodes = path.getNodes();
        return nodes.size() >= 4 && path.getLastNode().getIndex() == 0 && "route".equals(((MulePathNode)nodes.get(nodes.size() - 4)).getMarker()) && !this.isFirstChoiceRoute(path, muleConfig);
    }

    private boolean isFirstChoiceRoute(MulePath path, MuleConfiguration muleConfig) {
        MessageFlowEntity routeEntity = muleConfig.getEntityFor(this.getLevelPath(path, path.getNodes().size() - 4));
        return routeEntity != null && "choice".equals(routeEntity.getElement().getName()) && ((MulePathNode)path.getNodes().get(path.getNodes().size() - 3)).getIndex() == 0;
    }

    protected void replaceRelativeParent(IMuleProject muleProject, MuleConfiguration muleConfig, List<BreakpointDefinition> oldBreakpoints, MulePath oldPath, MulePath path) {
        int oldSize = oldPath.getNodes().size();
        for (BreakpointDefinition breakpoint : oldBreakpoints) {
            MulePath newPath = MulePath.fromPath((String)path.toPath());
            MulePath oldBreakpointPath = MulePath.fromPath((String)breakpoint.getPath());
            int size = oldSize + 1;
            while (size <= oldBreakpointPath.getNodes().size()) {
                newPath.addNode(new MulePathNode(oldBreakpointPath.getFlowName(), ((MulePathNode)oldBreakpointPath.getNodes().get(size - 1)).getMarker()));
                ++size;
            }
            BreakpointDefinition newBreakpoint = new BreakpointDefinition(breakpoint);
            newBreakpoint.setPath(newPath.toPath());
            newBreakpoint.setConfigName(muleConfig.getName());
            this.addBreakpoint(newBreakpoint);
        }
    }

    protected List<BreakpointDefinition> getBreakpointsFromPath(MulePath path) {
        ArrayList<BreakpointDefinition> onPath = new ArrayList<BreakpointDefinition>();
        if (path != null) {
            for (BreakpointDefinition breakpoint : this.breakpoints) {
                if (!breakpoint.getPath().startsWith(path.toPath())) continue;
                onPath.add(breakpoint);
            }
        }
        return onPath;
    }

    private void loadPersistedMarkersIfNotLoaded() {
        if (!this.alreadyLoadedPersistedMarkers) {
            this.loadBreakpoints();
            this.alreadyLoadedPersistedMarkers = true;
        }
    }

    private void loadBreakpoints() {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.getWorkspaceRoot().findMarkers(MULE_BREAKPOINT_MARKER, true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                BreakpointDefinition breakpointDef = new BreakpointDefinition(marker);
                this.doAddBreakpoint(breakpointDef);
                this.breakpointMarkerForDefsMap.put(breakpointDef, marker);
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("There was an error loading the breakpoints", e);
        }
    }

    public boolean containsBreakpoint(BreakpointDefinition breakpoint) {
        this.loadPersistedMarkersIfNotLoaded();
        return this.breakpoints.contains(breakpoint);
    }

    public BreakpointDefinition findBreakpoint(BreakpointDefinition breakpoint) {
        for (BreakpointDefinition currentBreakpoint : this.breakpoints) {
            if (!breakpoint.equals(currentBreakpoint)) continue;
            return currentBreakpoint;
        }
        return null;
    }

    public BreakpointDefinition findBreakpointFromAppConfigAndPath(String appName, String muleConfigName, String path) {
        for (BreakpointDefinition currentBreakpoint : this.findBreakpointsFromXmlConfigFile(appName, muleConfigName)) {
            if (!path.equals(currentBreakpoint.getPath())) continue;
            return currentBreakpoint;
        }
        return null;
    }

    public BreakpointDefinition findBreakpointFromPath(String path) {
        for (BreakpointDefinition currentBreakpoint : this.breakpoints) {
            if (!path.equals(currentBreakpoint.getPath())) continue;
            return currentBreakpoint;
        }
        return null;
    }

    public Collection<BreakpointDefinition> findBreakpointsFromProject(String projectName) {
        ArrayList<BreakpointDefinition> list = new ArrayList<BreakpointDefinition>();
        for (BreakpointDefinition bkpoint : this.breakpoints) {
            if (!bkpoint.getAppName().equals(projectName)) continue;
            list.add(bkpoint);
        }
        return list;
    }

    private List<BreakpointDefinition> findBreakpointsFromMarkersWithProjectName(String projectName) {
        return this.breakpointMarkerForDefsMap.keySet().stream().filter(bp -> bp.getAppName().equals(projectName)).collect(Collectors.toList());
    }

    public Collection<BreakpointDefinition> findBreakpointsFromXmlConfigFile(String projectName, String xmlConfigFileName) {
        ArrayList<BreakpointDefinition> list = new ArrayList<BreakpointDefinition>();
        for (BreakpointDefinition bkpoint : this.breakpoints) {
            if (!bkpoint.getAppName().equals(projectName) || !bkpoint.getConfigName().equals(xmlConfigFileName)) continue;
            list.add(bkpoint);
        }
        return list;
    }

    public void addBreakpoint(BreakpointDefinition breakpoint) {
        this.doAddBreakpoint(breakpoint);
        this.createMarker(breakpoint);
        this.updateBreakpointFigures();
    }

    private void doAddBreakpoint(BreakpointDefinition breakpoint) {
        this.breakpoints.add(breakpoint);
        breakpoint.addObserver(this.breakpointDefObserver);
        this.setChanged();
        this.notifyObservers("addBreakpoint");
        if (this.debuggerClient != null && !this.isMuteBreakpoints() && breakpoint.isEnabled()) {
            this.debuggerClient.addBreakpoints(new Breakpoint[]{breakpoint.toBreakpoint()});
        }
    }

    public void removeBreakpoint(BreakpointDefinition breakpoint) {
        HashSet<BreakpointDefinition> breakpointsToUpdate = new HashSet<BreakpointDefinition>(this.breakpoints);
        this.doRemoveBreakpoint(breakpoint);
        this.deleteMarker(breakpoint);
        this.updateBreakpointFigures(breakpointsToUpdate);
    }

    private void doRemoveBreakpoint(BreakpointDefinition breakpoint) {
        this.breakpoints.remove(breakpoint);
        breakpoint.deleteObserver(this.breakpointDefObserver);
        this.setChanged();
        this.notifyObservers("removeBreakpoint");
        if (this.debuggerClient != null) {
            this.debuggerClient.removeBreakpoints(new Breakpoint[]{breakpoint.toBreakpoint()});
        }
    }

    private void muteBreakpoints() {
        this.setChanged();
        this.notifyObservers("muteBreakpoints");
        if (this.debuggerClient != null) {
            for (BreakpointDefinition breakpoint : this.getBreakpoints()) {
                this.debuggerClient.removeBreakpoints(new Breakpoint[]{breakpoint.toBreakpoint()});
            }
        }
        this.updateBreakpointFigures();
    }

    private void unmuteBreakpoints() {
        this.setChanged();
        this.notifyObservers("unmuteBreakpoints");
        if (this.debuggerClient != null) {
            for (BreakpointDefinition breakpoint : this.getBreakpoints()) {
                if (!breakpoint.isEnabled()) continue;
                this.debuggerClient.addBreakpoints(new Breakpoint[]{breakpoint.toBreakpoint()});
            }
        }
        this.updateBreakpointFigures();
    }

    public void enableBreakpoint(BreakpointDefinition breakpoint) {
        this.setChanged();
        this.notifyObservers("enableBreakpoint");
        if (this.debuggerClient != null) {
            this.debuggerClient.addBreakpoints(new Breakpoint[]{breakpoint.toBreakpoint()});
        }
        this.updateBreakpointFigures();
    }

    public void disableBreakpoint(BreakpointDefinition breakpoint) {
        this.setChanged();
        this.notifyObservers("disableBreakpoint");
        if (this.debuggerClient != null) {
            this.debuggerClient.removeBreakpoints(new Breakpoint[]{breakpoint.toBreakpoint()});
        }
        this.updateBreakpointFigures();
    }

    public void removeAllBreakpoints() {
        if (this.debuggerClient != null) {
            Breakpoint[] breakpointsToRemove = new Breakpoint[this.breakpoints.size()];
            int i = 0;
            for (BreakpointDefinition breakpoint : this.breakpoints) {
                breakpointsToRemove[i] = breakpoint.toBreakpoint();
                ++i;
            }
            this.debuggerClient.removeBreakpoints(breakpointsToRemove);
        }
        for (BreakpointDefinition breakpoint : this.breakpoints) {
            breakpoint.deleteObserver(this.breakpointDefObserver);
            this.deleteMarker(breakpoint);
        }
        HashSet<BreakpointDefinition> breakpointsToUpdate = new HashSet<BreakpointDefinition>(this.breakpoints);
        this.breakpoints.clear();
        this.setChanged();
        this.notifyObservers("removeAllBreakpoints");
        this.updateBreakpointFigures(breakpointsToUpdate);
    }

    public Collection<BreakpointDefinition> getBreakpoints() {
        this.loadPersistedMarkersIfNotLoaded();
        return Collections.unmodifiableCollection(this.breakpoints);
    }

    public BreakpointDefinition getBreakpointForPath(String path) {
        this.loadPersistedMarkersIfNotLoaded();
        for (BreakpointDefinition breakpoint : this.breakpoints) {
            if (!breakpoint.getPath().equalsIgnoreCase(path)) continue;
            return breakpoint;
        }
        return null;
    }

    public void setExceptionBreakpointEnabled(boolean exceptionBreakpointEnabled) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        preferenceStore.setValue("exception-breakpoint-enabled", exceptionBreakpointEnabled);
        if (this.debuggerClient != null) {
            this.debuggerClient.enableExceptionBreakpoint(exceptionBreakpointEnabled);
        }
    }

    public boolean isExceptionBreakpointEnabled() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("exception-breakpoint-enabled");
    }

    public IMarker createMarker(BreakpointDefinition def) {
        try {
            IWorkspaceRoot root = this.getWorkspaceRoot();
            IMarker marker = root.createMarker(MULE_BREAKPOINT_MARKER);
            marker.setAttribute(BREAKPOINT_ENABLED, def.isEnabled());
            marker.setAttribute(BREAKPOINT_PATH, (Object)def.getPath());
            marker.setAttribute(BREAKPOINT_APP_NAME, (Object)def.getAppName());
            marker.setAttribute(BREAKPOINT_CONFIG_NAME, (Object)def.getConfigName());
            marker.setAttribute(BREAKPOINT_NODE_NAME, (Object)def.getNodeName());
            marker.setAttribute(BREAKPOINT_ICON_PATH, (Object)def.getIconPath());
            this.breakpointMarkerForDefsMap.put(def, marker);
            return marker;
        }
        catch (CoreException e) {
            throw new RuntimeException("Could not create breakpoint marker", e);
        }
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root;
    }

    public void deleteMarker(BreakpointDefinition def) {
        try {
            IMarker marker = this.breakpointMarkerForDefsMap.get(def);
            if (marker != null && marker.exists()) {
                this.breakpointMarkerForDefsMap.remove(def);
                marker.delete();
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("Could not delete breakpoint marker", e);
        }
    }

    public boolean isMuteBreakpoints() {
        return this.muteBreakpoints;
    }

    public void setMuteBreakpoints(boolean muteBreakpoints) {
        if (muteBreakpoints) {
            this.muteBreakpoints();
        } else {
            this.unmuteBreakpoints();
        }
        this.muteBreakpoints = muteBreakpoints;
        this.debuggerEventBus.fireEvent((IEvent)new MuteBreakpointsEvent());
        this.updateBreakpointFigures();
    }

    private void updateBreakpointFigures() {
        Collection<BreakpointDefinition> breakpoints = MuleDebuggerService.getDefault().getBreakpointService().getBreakpoints();
        this.updateBreakpointFigures(breakpoints);
    }

    private void updateBreakpointFigures(Collection<BreakpointDefinition> breakpoints) {
        for (BreakpointDefinition breakpoint : breakpoints) {
            EntityEditPart<?> editPart = MuleDebuggerUtils.findEditPartFromPathInOpenEditors(breakpoint.getAppName(), breakpoint.getPath(), false);
            if (editPart == null) continue;
            editPart.updateFigure();
            editPart.getFigure().repaint();
        }
    }

    public void updateBreakpoints() {
        for (BreakpointDefinition breakpoint : this.breakpoints) {
            if (this.existsPath(breakpoint)) continue;
            this.removeBreakpoint(breakpoint);
        }
    }

    private boolean existsPath(BreakpointDefinition breakpoint) {
        return MessageFlowUtils.findEntityForMulePathInOpenEditors((String)breakpoint.getPath(), (String)breakpoint.getAppName()) != null;
    }

    private void updateFromTo(MulePath oldPath, MulePath path, MuleConfiguration muleconfig) {
        int size = path.getNodes().size();
        int oldSize = oldPath.getNodes().size();
        MulePath oldLevelPath = this.getLevelPath(oldPath, oldSize - 1);
        MulePath newLevelPath = this.getLevelPath(path, size - 1);
        if (size == oldSize && oldLevelPath.toPath().equals(newLevelPath.toPath())) {
            this.updateSameLevel(oldPath, path, size);
        } else {
            this.updateLevel(oldPath, false, muleconfig);
            this.updateLevel(path, true, muleconfig);
        }
    }

    private void updateSameLevel(MulePath oldPath, MulePath path, int size) {
        try {
            int oldIndex = Integer.parseInt(((MulePathNode)oldPath.getNodes().get(--size)).getMarker());
            int newIndex = Integer.parseInt(((MulePathNode)path.getNodes().get(size)).getMarker());
            boolean increase = newIndex < oldIndex;
            List<Object> breakpointsToMove = new ArrayList();
            breakpointsToMove = increase ? this.getBreakpointsBetween(newIndex, oldIndex - 1, size) : this.getBreakpointsBetween(oldIndex + 1, newIndex, size);
            this.moveBreakpoints(size, increase, breakpointsToMove);
        }
        catch (NumberFormatException e) {
            MuleCorePlugin.logError((String)"Cant parse int from path", (Throwable)e);
        }
    }

    private void updateLevel(MulePath path, boolean increase, MuleConfiguration muleConfig) {
        if (this.shouldUpdateRouteLevel(path, muleConfig)) {
            int i = path.getNodes().lastIndexOf(new MulePathNode(path.getFlowName(), "route"));
            this.doUpdateLevel(path, i + 1, increase);
        } else {
            this.doUpdateLevel(path, path.getNodes().size() - 1, increase);
        }
    }

    private void doUpdateLevel(MulePath path, int level, boolean increase) {
        if (!MessageFlowUtils.isSourcePath((MulePath)path)) {
            try {
                int index = Integer.parseInt(((MulePathNode)path.getNodes().get(level)).getMarker());
                List<BreakpointDefinition> breakpointsToMove = this.getBreakpointsLevel(path, index, level);
                this.moveBreakpoints(level, increase, breakpointsToMove);
            }
            catch (NumberFormatException e) {
                MuleCorePlugin.logError((String)"Cant parse int from path", (Throwable)e);
            }
        }
    }

    private void moveBreakpoints(int size, boolean increase, List<BreakpointDefinition> breakpointsToMove) {
        ArrayList<BreakpointDefinition> newBreakpoints = new ArrayList<BreakpointDefinition>();
        for (BreakpointDefinition breakpoint : breakpointsToMove) {
            String newPath;
            String breakpointPath = breakpoint.getPath();
            BreakpointDefinition movedBreakpoint = this.moveBreakpoint(breakpointPath, newPath = this.modifyPath(MulePath.fromPath((String)breakpointPath), size, increase));
            if (movedBreakpoint == null) continue;
            newBreakpoints.add(movedBreakpoint);
        }
        this.removeBreakpoints(breakpointsToMove);
        this.addBreakpoints(newBreakpoints);
    }

    private void onFlowRenamed(List<BreakpointDefinition> oldBreakpoints, String oldName, String newName) {
        ArrayList<BreakpointDefinition> newBreakpoints = new ArrayList<BreakpointDefinition>();
        for (BreakpointDefinition breakpoint : oldBreakpoints) {
            MulePath oldMulePath = MulePath.fromPath((String)breakpoint.getPath());
            MulePath newMulePath = MulePath.fromPath((String)newName);
            int i = 0;
            while (i < oldMulePath.getNodes().size()) {
                newMulePath.addNode((MulePathNode)oldMulePath.getNodes().get(i));
                ++i;
            }
            BreakpointDefinition movedBreakpoint = this.moveBreakpoint(oldMulePath.toPath(), newMulePath.toPath());
            newBreakpoints.add(movedBreakpoint);
        }
        this.removeBreakpoints(oldBreakpoints);
        this.addBreakpoints(newBreakpoints);
    }

    private void removeBreakpoints(List<BreakpointDefinition> breakpointsToMove) {
        for (BreakpointDefinition breakpoint : breakpointsToMove) {
            this.removeBreakpoint(breakpoint);
        }
    }

    private void addBreakpoints(List<BreakpointDefinition> newBreakpoints) {
        for (BreakpointDefinition breakpoint : newBreakpoints) {
            this.addBreakpoint(breakpoint);
        }
    }

    private List<BreakpointDefinition> getBreakpointsLevel(MulePath path, int from, int level) {
        MulePath levelPath = this.getLevelPath(path, level);
        ArrayList<BreakpointDefinition> list = new ArrayList<BreakpointDefinition>();
        for (BreakpointDefinition breakpoint : this.breakpoints) {
            String breakpointPath = breakpoint.getPath();
            MulePath mulePath = MulePath.fromPath((String)breakpointPath);
            try {
                int index;
                String levelPathToString = levelPath.toPath() + "/";
                if (!breakpointPath.startsWith(levelPathToString) || (index = Integer.parseInt(((MulePathNode)mulePath.getNodes().get(level)).getMarker())) < from) continue;
                list.add(breakpoint);
            }
            catch (NumberFormatException e) {
                MuleCorePlugin.logError((String)"Cant parse int form path", (Throwable)e);
                return list;
            }
        }
        return list;
    }

    private MulePath getLevelPath(MulePath path, int level) {
        MulePath levelPath = new MulePath(path.getFlowName());
        int toAdd = 0;
        while (toAdd < level) {
            levelPath.addNode((MulePathNode)path.getNodes().get(toAdd));
            ++toAdd;
        }
        return levelPath;
    }

    private List<BreakpointDefinition> getBreakpointsBetween(int from, int to, int size) {
        ArrayList<BreakpointDefinition> list = new ArrayList<BreakpointDefinition>();
        for (BreakpointDefinition breakpoint : this.breakpoints) {
            MulePath mulePath = MulePath.fromPath((String)breakpoint.getPath());
            if (mulePath.getNodes().size() < size + 1) continue;
            try {
                int i = Integer.parseInt(((MulePathNode)mulePath.getNodes().get(size)).getMarker());
                if (i > to || i < from) continue;
                list.add(breakpoint);
            }
            catch (NumberFormatException e) {
                MuleCorePlugin.logError((String)"Cant parse int from path", (Throwable)e);
                return list;
            }
        }
        return list;
    }

    private String modifyPath(MulePath original, int nodeToModify, boolean increase) {
        MulePathNode mulePathNode = (MulePathNode)original.getNodes().get(nodeToModify);
        String node = mulePathNode.getMarker();
        if (node != null) {
            int i;
            try {
                i = Integer.parseInt(node);
                i = increase ? i + 1 : i - 1;
            }
            catch (NumberFormatException e) {
                MuleCorePlugin.logError((String)"Can't parse int from path", (Throwable)e);
                return null;
            }
            original.getNodes().set(nodeToModify, new MulePathNode(mulePathNode.getFlowName(), Integer.toString(i)));
        }
        return original.toPath();
    }

    private BreakpointDefinition moveBreakpoint(String origin, String destin) {
        BreakpointDefinition breakpoint = this.findBreakpointFromPath(origin);
        BreakpointDefinition newBreakpoint = null;
        if (breakpoint != null) {
            newBreakpoint = new BreakpointDefinition(breakpoint);
            newBreakpoint.setPath(destin);
        }
        return newBreakpoint;
    }

    private class BreakpointDefinitionObserver
    implements Observer {
        private BreakpointDefinitionObserver() {
        }

        @Override
        public void update(Observable observableBreakpoint, Object operationName) {
            BreakpointDefinition breakpointDef = (BreakpointDefinition)observableBreakpoint;
            IMarker marker = MuleBreakpointService.this.breakpointMarkerForDefsMap.get(breakpointDef);
            try {
                if ("setConditional".equals(operationName)) {
                    marker.setAttribute(MuleBreakpointService.BREAKPOINT_IS_CONDITIONAL, breakpointDef.isConditional());
                } else if ("setConditionScript".equals(operationName)) {
                    marker.setAttribute(MuleBreakpointService.BREAKPOINT_CONDITION, (Object)breakpointDef.getConditionScript());
                } else if ("setEnabled".equals(operationName)) {
                    marker.setAttribute(MuleBreakpointService.BREAKPOINT_ENABLED, (Object)breakpointDef.getConditionScript());
                }
            }
            catch (CoreException e) {
                throw new RuntimeException("Error updating breakpoint condition attribute", e);
            }
            if (MuleBreakpointService.this.debuggerClient != null) {
                boolean isConditionUpdated;
                boolean bl = isConditionUpdated = "setConditional".equals(operationName) || "setConditionScript".equals(operationName);
                if (isConditionUpdated && breakpointDef.isEnabled()) {
                    Breakpoint breakpoint = breakpointDef.toBreakpoint();
                    MuleBreakpointService.this.debuggerClient.removeBreakpoints(new Breakpoint[]{breakpoint});
                    MuleBreakpointService.this.debuggerClient.addBreakpoints(new Breakpoint[]{breakpoint});
                }
            }
        }
    }
}

