/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.service;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.ui.contribution.debugger.controller.ExpressionFieldDefinition;
import org.mule.tooling.ui.contribution.debugger.view.impl.MuleDebuggerView;

public class ExpressionWatchesService {
    private static final String EXPRESSION_WATCHES_MARKER = "org.mule.tooling.ui.contribution.debugger.expressionWatchesMarker";
    private static final String EXPRESSION = "expression";
    private Map<ExpressionFieldDefinition, IMarker> wacthesMarkerForDefsMap = new HashMap<ExpressionFieldDefinition, IMarker>();
    private boolean alreadyLoadedPersistedMarkers = false;

    public void loadPersistedMarkersIfNotLoaded() {
        if (!this.alreadyLoadedPersistedMarkers) {
            this.alreadyLoadedPersistedMarkers = true;
            this.loadWatchesFromMarkers();
        }
    }

    private void loadWatchesFromMarkers() {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.getWorkspaceRoot().findMarkers(EXPRESSION_WATCHES_MARKER, true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String expression = marker.getAttribute(EXPRESSION, "");
                if (!expression.isEmpty()) {
                    ExpressionFieldDefinition expressionFieldDefinition = new ExpressionFieldDefinition(expression);
                    this.wacthesMarkerForDefsMap.put(expressionFieldDefinition, marker);
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewPart view = page.findView("org.mule.tooling.ui.contribution.debugger.view");
                    if (view instanceof MuleDebuggerView) {
                        ((MuleDebuggerView)view).addExpressionWatchFromMarker(expressionFieldDefinition);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("There was an error loading the watches", e);
        }
    }

    public void createMarker(ExpressionFieldDefinition expressionFieldDefinition) {
        try {
            this.loadPersistedMarkersIfNotLoaded();
            IWorkspaceRoot root = this.getWorkspaceRoot();
            IMarker marker = root.createMarker(EXPRESSION_WATCHES_MARKER);
            marker.setAttribute(EXPRESSION, (Object)expressionFieldDefinition.getName());
            this.wacthesMarkerForDefsMap.put(expressionFieldDefinition, marker);
        }
        catch (CoreException e) {
            throw new RuntimeException("Could not create watches marker", e);
        }
    }

    public void deleteMarker(ExpressionFieldDefinition expressionFieldDefinition) {
        try {
            this.loadPersistedMarkersIfNotLoaded();
            IMarker marker = this.wacthesMarkerForDefsMap.get((Object)expressionFieldDefinition);
            if (marker != null && marker.exists()) {
                this.wacthesMarkerForDefsMap.remove((Object)expressionFieldDefinition);
                marker.delete();
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("Could not delete watches marker", e);
        }
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

