/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.service;

import com.mulesoft.mule.debugger.dto.Breakpoint;
import com.mulesoft.mule.debugger.util.MessageProcessorPathTokenizer;
import java.util.List;
import java.util.Observable;
import java.util.Optional;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.core.IconsLocator;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.model.messageflow.path.MulePath;

public class BreakpointDefinition
extends Observable {
    public static final String SET_ENABLED = "setEnabled";
    public static final String SET_CONDITION_SCRIPT = "setConditionScript";
    public static final String SET_CONDITIONAL = "setConditional";
    private String path;
    private boolean enabled;
    private String conditionScript;
    private boolean isConditional;
    private String appName;
    private String configName;
    private String nodeName;
    private String iconPath;
    private long creationTime;

    public BreakpointDefinition(String appName, String configName, String path) {
        this(appName, configName, path, null, null, true, false, null, System.currentTimeMillis());
    }

    public BreakpointDefinition(IMarker marker) {
        this(marker.getAttribute("appName", ""), marker.getAttribute("configName", ""), marker.getAttribute("path", ""), marker.getAttribute("nodeName", ""), marker.getAttribute("iconPath", ""), marker.getAttribute("enabled", true), marker.getAttribute("conditional", false), marker.getAttribute("condition", ""), Optional.ofNullable(marker.getAttribute("creationTime", null)).map(Long::valueOf).orElse(System.currentTimeMillis()));
    }

    public BreakpointDefinition(BreakpointDefinition breakpoint) {
        this(breakpoint.getAppName(), breakpoint.getConfigName(), breakpoint.getPath(), breakpoint.getNodeName(), breakpoint.getIconPath(), breakpoint.isEnabled(), breakpoint.isConditional(), breakpoint.getConditionScript(), breakpoint.getCreationTime());
    }

    public BreakpointDefinition(String appName, String configName, String path, String nodeName, String iconPath, Boolean enabled, Boolean conditional, String conditionScript, Long creationTime) {
        this.appName = appName;
        this.configName = configName;
        this.path = path;
        this.nodeName = nodeName;
        this.iconPath = iconPath;
        this.enabled = enabled;
        this.isConditional = conditional;
        this.conditionScript = conditionScript;
        this.creationTime = creationTime;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setChanged();
        this.notifyObservers(SET_ENABLED);
    }

    public boolean isConditional() {
        return this.isConditional;
    }

    public void setConditional(boolean isConditional) {
        this.isConditional = isConditional;
        this.setChanged();
        this.notifyObservers(SET_CONDITIONAL);
    }

    public String getConditionScript() {
        return this.conditionScript == null ? "" : this.conditionScript;
    }

    public String getFlowName() {
        return MulePath.fromPath((String)this.path).getFlowName();
    }

    public String getMPNumber() {
        Object result = "";
        List split = new MessageProcessorPathTokenizer().tokens(this.getPath());
        int i = 0;
        for (String element : split) {
            if (i > 1) {
                result = ((String)result).isEmpty() ? element : (String)result + "/" + element;
            }
            ++i;
        }
        return result;
    }

    public String getType() {
        List split = new MessageProcessorPathTokenizer().tokens(this.getPath());
        if (split.size() >= 2) {
            return (String)split.get(1);
        }
        return "";
    }

    public void clearConditionScript() {
        this.setConditionScript("");
    }

    public void setConditionScript(String conditionScript) {
        this.conditionScript = conditionScript;
        this.setChanged();
        this.notifyObservers(SET_CONDITION_SCRIPT);
    }

    public Breakpoint toBreakpoint() {
        if (this.isConditional) {
            return new Breakpoint(this.path, "#[" + this.getConditionScript() + "]", this.appName);
        }
        return new Breakpoint(this.path, this.appName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.appName == null ? 0 : this.appName.hashCode());
        result = 31 * result + (this.configName == null ? 0 : this.configName.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BreakpointDefinition)) {
            return false;
        }
        BreakpointDefinition other = (BreakpointDefinition)obj;
        if (this.appName == null ? other.appName != null : !this.appName.equals(other.appName)) {
            return false;
        }
        if (this.configName == null ? other.configName != null : !this.configName.equals(other.configName)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Image getIconImage() {
        return Optional.ofNullable(IconsLocator.getImage((String)this.getIconPath())).orElseGet(() -> ImagesManager.getInstance().getPaletteUnknown());
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public String toString() {
        return this.getNodeName() + " [" + this.getType() + ":" + this.getMPNumber() + "] - " + this.getFlowName() + " - " + this.getConfigName();
    }
}

