/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.refactors;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.contribution.debugger.service.BreakpointDefinition;
import org.mule.tooling.ui.contribution.debugger.service.MuleBreakpointService;

public class RenameBreakpointsProjectChange
extends Change {
    private MuleBreakpointService service;
    private Collection<BreakpointDefinition> breakpoints;
    private String oldName;
    private String newName;

    public RenameBreakpointsProjectChange(MuleBreakpointService breakpointService, Collection<BreakpointDefinition> breakpoints, String oldName, String newName) {
        this.service = breakpointService;
        this.breakpoints = breakpoints;
        this.oldName = oldName;
        this.newName = newName;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                for (BreakpointDefinition b : RenameBreakpointsProjectChange.this.breakpoints) {
                    RenameBreakpointsProjectChange.this.service.removeBreakpoint(b);
                }
                for (BreakpointDefinition b : RenameBreakpointsProjectChange.this.breakpoints) {
                    BreakpointDefinition breakpoint = new BreakpointDefinition(b);
                    breakpoint.setAppName(RenameBreakpointsProjectChange.this.newName);
                    RenameBreakpointsProjectChange.this.service.addBreakpoint(breakpoint);
                }
            }
        });
        Collection<BreakpointDefinition> newBreakpoints = this.service.findBreakpointsFromProject(this.newName);
        return new RenameBreakpointsProjectChange(this.service, newBreakpoints, this.newName, this.oldName);
    }

    public String getName() {
        return "Rename project in breakpoints";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        return status;
    }

    public Object getModifiedElement() {
        return null;
    }
}

