/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.refactors;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.contribution.debugger.service.BreakpointDefinition;
import org.mule.tooling.ui.contribution.debugger.service.MuleBreakpointService;

public class RenameBreakpointsChange
extends Change {
    private MuleBreakpointService service;
    private Collection<BreakpointDefinition> breakpoints;
    private String projectName;
    private String oldName;
    private String newName;

    public RenameBreakpointsChange(MuleBreakpointService breakpointService, Collection<BreakpointDefinition> breakpoints, String projectName, String oldName, String newName) {
        this.service = breakpointService;
        this.breakpoints = breakpoints;
        this.projectName = projectName;
        this.oldName = oldName;
        this.newName = newName;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                for (BreakpointDefinition b : RenameBreakpointsChange.this.breakpoints) {
                    RenameBreakpointsChange.this.service.removeBreakpoint(b);
                }
                for (BreakpointDefinition b : RenameBreakpointsChange.this.breakpoints) {
                    BreakpointDefinition breakpoint = new BreakpointDefinition(b);
                    breakpoint.setConfigName(RenameBreakpointsChange.this.newName);
                    RenameBreakpointsChange.this.service.addBreakpoint(breakpoint);
                }
            }
        });
        Collection<BreakpointDefinition> newBreakpoints = this.service.findBreakpointsFromXmlConfigFile(this.projectName, this.newName);
        return new RenameBreakpointsChange(this.service, newBreakpoints, this.projectName, this.newName, this.oldName);
    }

    public String getName() {
        return "Rename config in breakpoints";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        return status;
    }

    public Object getModifiedElement() {
        return null;
    }
}

