/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.refactors;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.mule.tooling.ui.contribution.debugger.refactors.RenameBreakpointsProjectChange;
import org.mule.tooling.ui.contribution.debugger.service.BreakpointDefinition;
import org.mule.tooling.ui.contribution.debugger.service.MuleBreakpointService;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;

public class DebuggerProjectRenameParticipant
extends RenameParticipant {
    private IProject project;
    private Collection<BreakpointDefinition> breakpoints;
    private MuleBreakpointService breakpointService = MuleDebuggerService.getDefault().getBreakpointService();

    protected boolean initialize(Object element) {
        if (element instanceof IProject) {
            this.project = (IProject)element;
            return true;
        }
        return false;
    }

    public String getName() {
        return "Debugger project rename participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) {
        return null;
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException {
        this.breakpoints = this.breakpointService.findBreakpointsFromProject(this.project.getName());
        return super.createPreChange(pm);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.project != null) {
            return new RenameBreakpointsProjectChange(this.breakpointService, this.breakpoints, this.project.getName(), this.getArguments().getNewName());
        }
        return null;
    }
}

