/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.refactors;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.ui.contribution.debugger.refactors.RenameBreakpointsChange;
import org.mule.tooling.ui.contribution.debugger.service.BreakpointDefinition;
import org.mule.tooling.ui.contribution.debugger.service.MuleBreakpointService;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;

public class DebuggerMuleConfigRenameParticipant
extends RenameParticipant {
    private IFile fileToRename;
    private Collection<BreakpointDefinition> breakpoints;
    private MuleBreakpointService breakpointService = MuleDebuggerService.getDefault().getBreakpointService();

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            this.fileToRename = (IFile)element;
            return MuleResourceUtils.isConfigFile((IResource)this.fileToRename);
        }
        return false;
    }

    public String getName() {
        return "Debugger Mule Configuration rename hook";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return null;
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException {
        String renamedFileWithoutSuffix = this.removeFileExtension(this.fileToRename.getName());
        this.breakpoints = this.breakpointService.findBreakpointsFromXmlConfigFile(this.fileToRename.getProject().getName(), renamedFileWithoutSuffix);
        return super.createPreChange(pm);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.fileToRename != null) {
            return new RenameBreakpointsChange(this.breakpointService, this.breakpoints, this.fileToRename.getProject().getName(), this.removeFileExtension(this.fileToRename.getName()), this.removeFileExtension(this.getArguments().getNewName()));
        }
        return null;
    }

    private String removeFileExtension(String xmlConfigFileName) {
        return xmlConfigFileName.replaceAll("\\.xml", "");
    }
}

