/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.preferences;

import java.util.concurrent.Callable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.tooling.runtime.launch.IMuleLaunchArgumentsProvider;
import org.mule.tooling.ui.contribution.debugger.Activator;
import org.mule.tooling.ui.contribution.debugger.preferences.DebuggerPreferences;
import org.mule.tooling.utils.SilentRunner;

public class DebuggerVMArgumentsProvider
implements IMuleLaunchArgumentsProvider {
    private static final int BYTES_IN_MB = 0x100000;

    public void appendArguments(final StringBuffer sb, final ILaunch iLaunch) {
        if (!"debug".equals(iLaunch.getLaunchMode())) {
            return;
        }
        sb.append(this.createArgument("mule.debug.enable", true));
        sb.append(this.createArgument("mule.timeout.disable", DebuggerPreferences.isMuleTimeoutDisabled()));
        SilentRunner.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int port = iLaunch.getLaunchConfiguration().getAttribute("remote-debug-port", 6666);
                sb.append(DebuggerVMArgumentsProvider.this.createArgument("mule.debug.port", port));
                boolean suspend = iLaunch.getLaunchConfiguration().getAttribute("remote-debug-suspend", false);
                sb.append(DebuggerVMArgumentsProvider.this.createArgument("mule.debug.suspend", suspend));
                int maxConsumptionStreamSizeInMB = iLaunch.getLaunchConfiguration().getAttribute("remote-debug-max-stream-size", 2);
                long maxConsumptionStreamSizeInBytes = maxConsumptionStreamSizeInMB != -1 ? maxConsumptionStreamSizeInMB * 0x100000 : maxConsumptionStreamSizeInMB;
                sb.append(DebuggerVMArgumentsProvider.this.createArgument("mule.debug.max.consume.stream.size", maxConsumptionStreamSizeInBytes));
                int maxPayloadCollectionSize = iLaunch.getLaunchConfiguration().getAttribute("mule.debug.payload.max.collection.size", 100);
                sb.append(DebuggerVMArgumentsProvider.this.createArgument("mule.debug.max_length", maxPayloadCollectionSize));
                IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
                boolean hideInaccessibleFields = preferenceStore.getBoolean("mule.debugger.hide.inaccessible.fields");
                sb.append(DebuggerVMArgumentsProvider.this.createArgument("mule.debugger.hide.inaccessible.fields", hideInaccessibleFields));
                boolean hideInaccessibleFieldsOrigin = preferenceStore.getBoolean("mule.debugger.hide.inaccessible.fields.origin");
                sb.append(DebuggerVMArgumentsProvider.this.createArgument("mule.debugger.hide.inaccessible.fields.origin", hideInaccessibleFieldsOrigin));
                boolean acceptOnlyAssignableTypes = preferenceStore.getBoolean("mule.debugger.accept.only.assignable.types");
                sb.append(DebuggerVMArgumentsProvider.this.createArgument("mule.debugger.accept.only.assignable.types", acceptOnlyAssignableTypes));
                return null;
            }
        }, null);
    }

    private String createArgument(String property, Object value) {
        return " -D" + property + "=" + String.valueOf(value);
    }
}

