/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.preferences;

import org.mule.tooling.ui.contribution.debugger.Activator;
import org.mule.tooling.utils.exception.IllegalCreationException;

public class DebuggerPreferences {
    public static final String MULE_TIMEOUT_DISABLE = "mule.timeout.disable";
    public static final String MUTE_BREAKPOINTS_DISABLES_ERROR_BREAKPOINTS = "mute.breakpoints.disables.error.breakpoints";
    public static final String SWITCH_TO_DEBUG_PERSPECTIVE = "switch.to.debug.perspective";
    public static final String DEBUGGER_EVALUATOR_HISTORY_SIZE = "mule.debug.evaluator.history.size";
    public static final String DEBUGGER_DW_EXPRESSION_MAX_COLLECTION_SIZE = "mule.debug.dw.expression.max.collection.size";
    public static final String DEBUGGER_SHOW_JAVA_CLASSES = "mule.debug.show.java.classes";
    public static final String DEBUGGER_SHOW_JAVA_CLASSES_MOST_SIGNIFICATIVE_PART = "mule.debug.show.java.classes.most.significative.part";
    public static final String DEBUGGER_SHOW_JAVA_PRIMITIVE_CLASSES = "mule.debug.show.java.primitive.classes";
    public static final String JAVA_DEBUGGER_ENABLED = "java.debugger.enabled";
    public static final String HIDE_INACCESSIBLE_FIELDS = "mule.debugger.hide.inaccessible.fields";
    public static final String HIDE_INACCESSIBLE_FIELDS_ORIGIN = "mule.debugger.hide.inaccessible.fields.origin";
    public static final String ACCEPT_ONLY_ASSIGNABLE_TYPES = "mule.debugger.accept.only.assignable.types";

    private DebuggerPreferences() {
        throw new IllegalCreationException();
    }

    public static boolean isMuleTimeoutDisabled() {
        return Activator.getDefault().getPreferenceStore().getBoolean(MULE_TIMEOUT_DISABLE);
    }

    public static boolean isMuteBreakpointsDisablesErrorBreakpoints() {
        return Activator.getDefault().getPreferenceStore().getBoolean(MUTE_BREAKPOINTS_DISABLES_ERROR_BREAKPOINTS);
    }

    public static int amountOfItemsInHistory() {
        return Activator.getDefault().getPreferenceStore().getInt(DEBUGGER_EVALUATOR_HISTORY_SIZE);
    }

    public static int dwMaxCollectionSize() {
        return Activator.getDefault().getPreferenceStore().getInt(DEBUGGER_DW_EXPRESSION_MAX_COLLECTION_SIZE);
    }

    public static boolean showJavaClasses() {
        return Activator.getDefault().getPreferenceStore().getBoolean(DEBUGGER_SHOW_JAVA_CLASSES);
    }

    public static boolean showJavaClassesMostSignificativePart() {
        return Activator.getDefault().getPreferenceStore().getBoolean(DEBUGGER_SHOW_JAVA_CLASSES_MOST_SIGNIFICATIVE_PART);
    }

    public static boolean showJavaPrimitiveClasses() {
        return Activator.getDefault().getPreferenceStore().getBoolean(DEBUGGER_SHOW_JAVA_PRIMITIVE_CLASSES);
    }

    public static boolean javaDebuggerEnabled() {
        return Activator.getDefault().getPreferenceStore().getBoolean(JAVA_DEBUGGER_ENABLED);
    }
}

