/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.preferences;

import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.ui.contribution.debugger.Activator;
import org.mule.tooling.ui.contribution.debugger.controller.TreeNodeLabelProvider;
import org.mule.tooling.ui.contribution.debugger.preferences.DebuggerPreferences;
import org.mule.tooling.ui.contribution.debugger.view.impl.EvaluateView;

public class DebuggerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Group variablesViewPreference;
    private BooleanFieldEditor showJavaClasses;
    private BooleanFieldEditor showJavaClassesMostSignificativePart;
    private BooleanFieldEditor showJavaPrimitiveClasses;
    private IntegerFieldEditor historySize;
    private BooleanFieldEditor javaDebuggerFieldEditor;
    private Composite compositeJavaOptions;
    private Group inaccessibleFieldsPreference;
    private BooleanFieldEditor hideInaccessibleFieldsFieldEditor;
    private BooleanFieldEditor hideInaccessibleFieldsOriginFieldEditor;
    private BooleanFieldEditor acceptOnlyAssignableTypesFieldEditor;

    public DebuggerPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Debugger preferences");
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value") && event.getSource() == this.showJavaClasses) {
            boolean newValue = this.showJavaClasses.getBooleanValue();
            this.setEnabledButtons(newValue);
        } else if (event.getProperty().equals("field_editor_value") && event.getSource() == this.historySize) {
            int newValue = this.historySize.getIntValue();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart view = page.findView("org.mule.tooling.ui.contribution.debugger.evaluate");
            if (view instanceof EvaluateView) {
                ((EvaluateView)view).changeHistorySize(newValue);
            }
        } else if (event.getProperty().equals("field_editor_value") && event.getSource() == this.javaDebuggerFieldEditor) {
            DebugUITools.getPreferenceStore().setValue("java.debugger.enabled", this.javaDebuggerFieldEditor.getBooleanValue());
            AnalyticsRecordsFactory.single((String)Events.JAVA_DEBUGGER_ENABLED, (String[])new String[]{"value", String.valueOf(this.javaDebuggerFieldEditor.getBooleanValue())}).track();
        }
    }

    private void setEnabledButtons(boolean currentValue) {
        this.showJavaClassesMostSignificativePart.setEnabled(currentValue, this.compositeJavaOptions);
        this.showJavaPrimitiveClasses.setEnabled(currentValue, this.compositeJavaOptions);
    }

    protected void createFieldEditors() {
        RadioGroupFieldEditor switchToDebugPerspective = new RadioGroupFieldEditor("switch.to.debug.perspective", "Switch to Debug Perspective", 3, (String[][])new String[][]{{"Always", "always"}, {"Never", "never"}, {"Prompt", "prompt"}}, this.createComposite(this.getFieldEditorParent(), 1, 2, 768), true);
        switchToDebugPerspective.setPreferenceName("switch.to.debug.perspective");
        switchToDebugPerspective.setPreferenceStore(this.getPreferenceStore());
        this.addField((FieldEditor)switchToDebugPerspective);
        BooleanFieldEditor timeoutDisabledEditor = new BooleanFieldEditor("mule.timeout.disable", "Disable mule timeout", this.getFieldEditorParent());
        this.addField((FieldEditor)timeoutDisabledEditor);
        this.javaDebuggerFieldEditor = new BooleanFieldEditor("java.debugger.enabled", "Connect Java Debugger", this.getFieldEditorParent());
        this.addField((FieldEditor)this.javaDebuggerFieldEditor);
        BooleanFieldEditor muteBreakpointsMutesErrorBreakpoints = new BooleanFieldEditor("mute.breakpoints.disables.error.breakpoints", "Mute Breakpoints disables Error Breakpoints", this.getFieldEditorParent());
        this.addField((FieldEditor)muteBreakpointsMutesErrorBreakpoints);
        this.historySize = new IntegerFieldEditor("mule.debug.evaluator.history.size", "Script evaluator history size", this.getFieldEditorParent());
        this.addField((FieldEditor)this.historySize);
        this.variablesViewPreference = new Group(this.getFieldEditorParent(), 32);
        this.variablesViewPreference.setText("Variables view preferences");
        this.addField((FieldEditor)new IntegerFieldEditor("mule.debug.dw.expression.max.collection.size", "Maximum collection size introspection when copying values", (Composite)this.variablesViewPreference));
        this.showJavaClasses = new BooleanFieldEditor("mule.debug.show.java.classes", "Show Java classes", (Composite)this.variablesViewPreference);
        this.addField((FieldEditor)this.showJavaClasses);
        this.compositeJavaOptions = new Composite((Composite)this.variablesViewPreference, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.compositeJavaOptions);
        GridDataFactory.fillDefaults().indent(10, 0).applyTo((Control)this.compositeJavaOptions);
        this.showJavaClassesMostSignificativePart = new BooleanFieldEditor("mule.debug.show.java.classes.most.significative.part", "Show most significative part (the packages will be dropped)", this.compositeJavaOptions);
        this.addField((FieldEditor)this.showJavaClassesMostSignificativePart);
        this.showJavaPrimitiveClasses = new BooleanFieldEditor("mule.debug.show.java.primitive.classes", "Show primitive classes", this.compositeJavaOptions);
        ((Button)this.showJavaPrimitiveClasses.getDescriptionControl(this.compositeJavaOptions)).setToolTipText(String.format("The following classes won't be shown: %s", String.join((CharSequence)", ", TreeNodeLabelProvider.PRIMITIVE_JDK_CLASSES_TO_BE_SHOWN)));
        this.addField((FieldEditor)this.showJavaPrimitiveClasses);
        this.setEnabledButtons(DebuggerPreferences.showJavaClasses());
        this.inaccessibleFieldsPreference = new Group(this.getFieldEditorParent(), 32);
        this.inaccessibleFieldsPreference.setText("Inaccessible fields preferences (Java 17+)");
        this.hideInaccessibleFieldsFieldEditor = new BooleanFieldEditor("mule.debugger.hide.inaccessible.fields", "Hide inaccessible fields", (Composite)this.inaccessibleFieldsPreference);
        this.addField((FieldEditor)this.hideInaccessibleFieldsFieldEditor);
        this.hideInaccessibleFieldsOriginFieldEditor = new BooleanFieldEditor("mule.debugger.hide.inaccessible.fields.origin", "Hide public methods invoked to retrieve inaccesible field values", (Composite)this.inaccessibleFieldsPreference);
        this.addField((FieldEditor)this.hideInaccessibleFieldsOriginFieldEditor);
        this.acceptOnlyAssignableTypesFieldEditor = new BooleanFieldEditor("mule.debugger.accept.only.assignable.types", "Use only public method with assignable return type to retrieve inaccesible field values", (Composite)this.inaccessibleFieldsPreference);
        this.addField((FieldEditor)this.acceptOnlyAssignableTypesFieldEditor);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).applyTo((Composite)this.variablesViewPreference);
        GridDataFactory.swtDefaults().align(4, 1).span(2, 1).grab(true, false).applyTo((Control)this.variablesViewPreference);
    }

    private Composite createComposite(Composite parent, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }
}

