/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.launch;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.SilentRunner;

public class RemoteDebuggingLaunchConfigurationTab
extends AbstractLaunchConfigurationTab
implements IPropertyChangeListener {
    private StringFieldEditor hostFieldEditor;
    private IntegerFieldEditor portFieldEditor;
    private BooleanFieldEditor suspendFieldEditor;
    private Text properties;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        comp.setLayout((Layout)layout);
        Group group = new Group(comp, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Connection Properties:");
        group.setFont(parent.getFont());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        group.setLayoutData((Object)gridData);
        Composite connectionPropsComp = new Composite((Composite)group, 0);
        connectionPropsComp.setLayout((Layout)new GridLayout(2, false));
        connectionPropsComp.setFont(parent.getFont());
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 1;
        connectionPropsComp.setLayoutData((Object)gd2);
        PreferenceStore prefStore = new PreferenceStore();
        prefStore.setDefault("remote-debug-host", "localhost");
        prefStore.setDefault("remote-debug-port", 6666);
        this.hostFieldEditor = new StringFieldEditor("remote-debug-host", "Host:", connectionPropsComp);
        this.hostFieldEditor.setPreferenceStore((IPreferenceStore)prefStore);
        this.hostFieldEditor.load();
        this.hostFieldEditor.setPropertyChangeListener((IPropertyChangeListener)this);
        this.portFieldEditor = new IntegerFieldEditor("remote-debug-port", "Port:", connectionPropsComp);
        this.portFieldEditor.setPreferenceStore((IPreferenceStore)prefStore);
        this.portFieldEditor.load();
        this.portFieldEditor.setPropertyChangeListener((IPropertyChangeListener)this);
        this.suspendFieldEditor = new BooleanFieldEditor("remote-debug-suspend", "Suspend:", connectionPropsComp);
        this.suspendFieldEditor.setPreferenceStore((IPreferenceStore)prefStore);
        this.suspendFieldEditor.load();
        this.suspendFieldEditor.setPropertyChangeListener((IPropertyChangeListener)this);
        WidgetUtils widgetUtils = new WidgetUtils();
        this.properties = (Text)widgetUtils.createComponentWithLabel(Text.class, connectionPropsComp, "Mule Launcher Arguments", "Copy this properties to your mule launcher.", 2056);
        this.portFieldEditor.setPropertyChangeListener(event -> {
            this.updatePropertiesText();
            this.propertyChange(event);
        });
        this.suspendFieldEditor.setPropertyChangeListener(event -> {
            this.updatePropertiesText();
            this.propertyChange(event);
        });
        this.setControl((Control)comp);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration config) {
        SilentRunner.run(() -> {
            String host = config.getAttribute("remote-debug-host", "localhost");
            this.hostFieldEditor.getPreferenceStore().setValue("remote-debug-host", host);
            this.hostFieldEditor.setStringValue(host);
            int port = config.getAttribute("remote-debug-port", 6666);
            this.portFieldEditor.getPreferenceStore().setValue("remote-debug-port", port);
            this.portFieldEditor.setStringValue(Integer.toString(port));
            boolean suspend = config.getAttribute("remote-debug-suspend", false);
            this.suspendFieldEditor.getPreferenceStore().setValue("remote-debug-suspend", suspend);
            this.suspendFieldEditor.load();
            this.updatePropertiesText();
        });
    }

    private void updatePropertiesText() {
        this.properties.setText("-M-Dmule.debug.enable=true -M-Dmule.debug.suspend=" + this.suspendFieldEditor.getBooleanValue() + " -M-Dmule.debug.port=" + this.portFieldEditor.getStringValue());
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("remote-debug-host", this.hostFieldEditor.getStringValue());
        config.setAttribute("remote-debug-port", this.portFieldEditor.getIntValue());
        config.setAttribute("mule-remote-debug", true);
        config.setAttribute("remote-debug-suspend", this.suspendFieldEditor.getBooleanValue());
    }

    public String getName() {
        return "Connect";
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_LCL_DISCONNECT");
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateLaunchConfigurationDialog();
    }
}

