/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.launch;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.utils.SilentRunner;

public class DebugLaunchConfigurationTab
extends AbstractLaunchConfigurationTab
implements IPropertyChangeListener {
    private IntegerFieldEditor portFieldEditor;
    private BooleanFieldEditor suspendFieldEditor;
    private Boolean defaultSuspendValue;
    private IntegerFieldEditor maxConsumptionStreamSize;
    private BooleanFieldEditor unlimitedConsumptionStreamSize;
    private Composite streamPropsComp;
    private IntegerFieldEditor maxCollectionPayload;

    public DebugLaunchConfigurationTab() {
        this.defaultSuspendValue = false;
    }

    public DebugLaunchConfigurationTab(Boolean defaultSuspendValue) {
        this.defaultSuspendValue = defaultSuspendValue;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        comp.setLayout((Layout)layout);
        PreferenceStore prefStore = new PreferenceStore();
        Composite connectionPropsComp = this.createComposite(parent, comp, "Connection Properties:");
        this.portFieldEditor = new IntegerFieldEditor("remote-debug-port", "Debugger Port:", connectionPropsComp);
        this.initialize((FieldEditor)this.portFieldEditor, (IPreferenceStore)prefStore);
        this.suspendFieldEditor = new BooleanFieldEditor("remote-debug-suspend", "Suspend", connectionPropsComp);
        this.initialize((FieldEditor)this.suspendFieldEditor, (IPreferenceStore)prefStore);
        this.streamPropsComp = this.createComposite(parent, comp, "Debugger Maximum Consumption Stream Properties:");
        this.maxConsumptionStreamSize = new IntegerFieldEditor("remote-debug-max-stream-size", "Max Size (in MB):", this.streamPropsComp);
        this.initialize((FieldEditor)this.maxConsumptionStreamSize, (IPreferenceStore)prefStore);
        this.unlimitedConsumptionStreamSize = new BooleanFieldEditor("remote-debug-unlimited-stream-size", "Unlimited Size", this.streamPropsComp);
        this.initialize((FieldEditor)this.unlimitedConsumptionStreamSize, (IPreferenceStore)prefStore);
        Composite payloadCollectionProps = this.createComposite(parent, comp, "Debugger Maximum Payload Collection Size:");
        this.maxCollectionPayload = new IntegerFieldEditor("mule.debug.payload.max.collection.size", "Maximum Amount Allowed:", payloadCollectionProps);
        this.initialize((FieldEditor)this.maxCollectionPayload, (IPreferenceStore)prefStore);
        this.setControl((Control)comp);
    }

    private Composite createComposite(Composite parent, Composite comp, String name) {
        Group g = new Group(comp, 0);
        g.setLayout((Layout)new GridLayout(1, false));
        g.setText(name);
        g.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        g.setLayoutData((Object)gd);
        Composite connectionPropsComp = new Composite((Composite)g, 0);
        connectionPropsComp.setLayout((Layout)new GridLayout(2, false));
        connectionPropsComp.setFont(parent.getFont());
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 1;
        connectionPropsComp.setLayoutData((Object)gd2);
        return connectionPropsComp;
    }

    private void initialize(FieldEditor fe, IPreferenceStore prefStore) {
        fe.setPreferenceStore(prefStore);
        fe.load();
        fe.setPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration config) {
        SilentRunner.run(() -> {
            int port = config.getAttribute("remote-debug-port", 6666);
            this.portFieldEditor.getPreferenceStore().setValue("remote-debug-port", port);
            this.portFieldEditor.setStringValue(Integer.toString(port));
            int maxSize = config.getAttribute("remote-debug-max-stream-size", 2);
            this.maxConsumptionStreamSize.getPreferenceStore().setValue("remote-debug-max-stream-size", maxSize);
            this.maxConsumptionStreamSize.setStringValue(Integer.toString(maxSize));
            boolean suspend = config.getAttribute("remote-debug-suspend", this.defaultSuspendValue.booleanValue());
            this.suspendFieldEditor.getPreferenceStore().setValue("remote-debug-suspend", suspend);
            this.suspendFieldEditor.load();
            int maxCollectionSize = config.getAttribute("mule.debug.payload.max.collection.size", 100);
            this.maxCollectionPayload.getPreferenceStore().setValue("mule.debug.payload.max.collection.size", maxCollectionSize);
            this.maxCollectionPayload.setStringValue(Integer.toString(maxCollectionSize));
        });
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("remote-debug-port", this.portFieldEditor.getIntValue());
        config.setAttribute("remote-debug-max-stream-size", this.maxConsumptionStreamSize.getIntValue());
        config.setAttribute("remote-debug-suspend", this.suspendFieldEditor.getBooleanValue());
        config.setAttribute("mule.debug.payload.max.collection.size", this.maxCollectionPayload.getIntValue());
    }

    public String getName() {
        return " Mule Debugger";
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_OBJS_LAUNCH_DEBUG");
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateLaunchConfigurationDialog();
        if (this.unlimitedConsumptionStreamSize.equals(event.getSource())) {
            boolean unlimitedSize = (Boolean)event.getNewValue();
            if (unlimitedSize) {
                this.maxConsumptionStreamSize.setStringValue(Integer.toString(-1));
                this.maxConsumptionStreamSize.setEnabled(false, this.streamPropsComp);
            } else {
                this.maxConsumptionStreamSize.setStringValue(Integer.toString(2));
                this.maxConsumptionStreamSize.setEnabled(true, this.streamPropsComp);
            }
        }
    }
}

