/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.decorator;

import com.mulesoft.mule.debugger.client.IDebuggerClient;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.figuredecorator.FigureDecoratorPosition;
import org.mule.tooling.messageflow.figuredecorator.IFigureDecorator;
import org.mule.tooling.messageflow.figuredecorator.IFigureDecoratorFactory;
import org.mule.tooling.messageflow.figuredecorator.OverlayIcon;
import org.mule.tooling.messageflow.util.MessageFlowEntityWrapper;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerImages;

public class SchedulerFigureDecoratorFactory
implements IFigureDecoratorFactory {
    public boolean decorates(MessageFlowEntity entity) {
        return MuleDebuggerService.getDefault().isDebugging() && ModelUtils.isScheduler((IMessageFlowEntity)entity);
    }

    public IFigureDecorator createDecorator(MessageFlowEntityWrapper wrapper) {
        MessageFlowEntity entity = wrapper.getEntity();
        PlayMouseListener playMouseListener = new PlayMouseListener(entity);
        OverlayIcon playOverlayIcon = new OverlayIcon(DebuggerImages.IMG_RESUME, (MouseListener)playMouseListener, 1);
        OutsideFigureDecorator playFigureDecorator = new OutsideFigureDecorator(playOverlayIcon);
        return playFigureDecorator;
    }

    private static final class OutsideFigureDecorator
    implements IFigureDecorator {
        private OverlayIcon outside;

        public OutsideFigureDecorator(OverlayIcon ovr) {
            this.outside = ovr;
        }

        public OverlayIcon getOverlay(FigureDecoratorPosition pos) {
            switch (pos) {
                case OUTSIDE: {
                    return this.outside;
                }
            }
            return null;
        }

        public List<OverlayIcon> getOverlayList(FigureDecoratorPosition pos) {
            switch (pos) {
                case OUTSIDE: {
                    return Collections.singletonList(this.getOverlay(pos));
                }
            }
            return null;
        }
    }

    private static final class PlayMouseListener
    implements MouseListener {
        private MulePath path;
        private IMuleProject muleProject;
        private final MessageFlowEntity entity;

        public PlayMouseListener(MessageFlowEntity entity) {
            this.entity = entity;
        }

        private MulePath getPath() {
            if (this.path == null) {
                MessageFlowEditor messageFlowEditor = MessageFlowUtils.getFlowEditorFromActivePage();
                MuleConfiguration muleConfig = (MuleConfiguration)messageFlowEditor.getModelRoot().getEntity();
                this.muleProject = messageFlowEditor.getMuleProject();
                this.path = MessageFlowUtils.findMulePathForEntity((IMuleProject)this.muleProject, (MuleConfiguration)muleConfig, (IMessageFlowEntity)this.entity);
            }
            return this.path;
        }

        public void mousePressed(MouseEvent me) {
            if (this.getPath() == null) {
                return;
            }
            IDebuggerClient client = MuleDebuggerService.getDefault().getDebuggerClient();
            client.triggerScheduler(this.muleProject.getName(), this.getPath().getFlowName(), false);
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }
}

