/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.decorator;

import org.mule.tooling.messageflow.figuredecorator.DefaultFigureDecorator;
import org.mule.tooling.messageflow.figuredecorator.IFigureDecorator;
import org.mule.tooling.messageflow.figuredecorator.IFigureDecoratorFactory;
import org.mule.tooling.messageflow.figuredecorator.OverlayIcon;
import org.mule.tooling.messageflow.util.MessageFlowEntityRef;
import org.mule.tooling.messageflow.util.MessageFlowEntityWrapper;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.ui.contribution.debugger.service.BreakpointDefinition;
import org.mule.tooling.ui.contribution.debugger.service.MuleBreakpointService;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.utils.MuleDebuggerUtils;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerImages;

public class MuleDebuggerFigureDecorator
implements IFigureDecoratorFactory {
    private static final MuleBreakpointService breakpointService = MuleDebuggerService.getDefault().getBreakpointService();
    private static final DefaultFigureDecorator BREAKPOINT_DECORATOR = new DefaultFigureDecorator(null, new OverlayIcon(DebuggerImages.getDebuggerImages().getImageDescriptor("icons/small/breakpoint-16x16.png"), null), null, null);
    private static final DefaultFigureDecorator BREAKPOINT_DISABLE_DECORATOR = new DefaultFigureDecorator(null, new OverlayIcon(DebuggerImages.getDebuggerImages().getImageDescriptor("icons/small/breakpoint-disabled-16x16.png"), null), null, null);
    private static final DefaultFigureDecorator BREAKPOINT_MUTE_DECORATOR = new DefaultFigureDecorator(null, new OverlayIcon(DebuggerImages.getDebuggerImages().getImageDescriptor("icons/small/breakpoint-muted-16x16.png"), null), null, null);
    private static final DefaultFigureDecorator BREAKPOINT_DISABLE_MUTE_DECORATOR = new DefaultFigureDecorator(null, new OverlayIcon(DebuggerImages.getDebuggerImages().getImageDescriptor("icons/small/breakpoint-disabled-muted-16x16.png"), null), null, null);

    public boolean decorates(MessageFlowEntity entity) {
        return MuleDebuggerUtils.supportsDebugging(entity);
    }

    public IFigureDecorator createDecorator(MessageFlowEntityWrapper wrapper) {
        MessageFlowEntityRef path = wrapper.getPath();
        if (path == null) {
            return null;
        }
        BreakpointDefinition breakpoint = new BreakpointDefinition(path.getMuleProject().getName(), path.getMuleConfiguration().getName(), path.getMulePath().toString());
        if (breakpointService.containsBreakpoint(breakpoint)) {
            BreakpointDefinition foundBreakpoint = breakpointService.findBreakpoint(breakpoint);
            if (foundBreakpoint.isEnabled()) {
                return breakpointService.isMuteBreakpoints() ? BREAKPOINT_MUTE_DECORATOR : BREAKPOINT_DECORATOR;
            }
            return breakpointService.isMuteBreakpoints() ? BREAKPOINT_DISABLE_MUTE_DECORATOR : BREAKPOINT_DISABLE_DECORATOR;
        }
        return null;
    }
}

