/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.decorator;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.events.EditPartEventTypes;
import org.mule.tooling.messageflow.events.IFigureCreatedEventListener;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class DebuggerHighlighter {
    private static DebuggerHighlighter instance;
    private IFigure lastHighlighted;
    private String lastHighlightedPath;
    private Border lastOriginalBorder;
    private boolean highlightPresent;
    private Color lastHighlightedColor;

    private DebuggerHighlighter() {
        EventBus eventBus = MuleCorePlugin.getEventBus();
        eventBus.registerListener(EditPartEventTypes.ON_FIGURE_CREATED, (IEventHandler)new IFigureCreatedEventListener(){

            public void onFigureCreated(EntityFigure<?> figure, MulePath path) {
                String pathStr = String.valueOf(path);
                if (DebuggerHighlighter.this.lastHighlightedPath != null && DebuggerHighlighter.this.lastHighlightedPath.equals(pathStr) && DebuggerHighlighter.this.highlightPresent && DebuggerHighlighter.this.lastHighlighted != figure) {
                    DebuggerHighlighter.this.unhighlight();
                    DebuggerHighlighter.this.highlight(pathStr, (IFigure)figure, DebuggerHighlighter.this.lastHighlightedColor);
                }
            }
        });
    }

    public void highlight(String path, IFigure figure, Color color) {
        this.restoreLastHighlighted();
        this.lastHighlightedPath = MessageFlowUtils.mulePathToStudioPath((String)path);
        this.lastHighlightedColor = color;
        this.lastHighlighted = figure;
        this.lastOriginalBorder = figure.getBorder() == null ? new MarginBorder(0) : figure.getBorder();
        Insets prevInsets = this.lastOriginalBorder.getInsets(figure);
        Color colorToUse = color;
        if (this.lastOriginalBorder instanceof MarginBorder) {
            figure.setBorder((Border)new CompoundBorder((Border)new RoundBorder(colorToUse, 2, 2), (Border)new MarginBorder(prevInsets.bottom - 2)));
        } else {
            CompoundBorder withMargin = new CompoundBorder((Border)new MarginBorder(5), this.lastOriginalBorder);
            figure.setBorder((Border)new CompoundBorder((Border)new RoundBorder(colorToUse, 2, 2), (Border)withMargin));
        }
        this.highlightPresent = true;
    }

    public static DebuggerHighlighter getInstance() {
        if (instance == null) {
            instance = new DebuggerHighlighter();
        }
        return instance;
    }

    public void restoreLastHighlighted() {
        this.highlightPresent = false;
        this.unhighlight();
    }

    private void unhighlight() {
        if (this.lastHighlighted == null) {
            return;
        }
        this.lastHighlighted.setBorder(this.lastOriginalBorder);
    }

    public boolean isHighlightPresent() {
        return this.highlightPresent;
    }

    private class RoundBorder
    extends LineBorder {
        public RoundBorder(Color color, int width, int style) {
            super(color, width, style);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            tempRect.setBounds(RoundBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            if (this.getWidth() % 2 == 1) {
                --RoundBorder.tempRect.width;
                --RoundBorder.tempRect.height;
            }
            tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
            graphics.setLineWidth(this.getWidth());
            graphics.setLineStyle(this.getStyle());
            if (this.getColor() != null) {
                graphics.setForegroundColor(this.getColor());
            }
            graphics.drawRoundRectangle(tempRect, 5, 5);
        }
    }
}

