/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.controller;

import com.mulesoft.mule.debugger.dto.MuleMessageInfo;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.contribution.debugger.controller.AbstractObjectFieldDefinitionController;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerEventTypes;
import org.mule.tooling.ui.contribution.debugger.controller.ExpressionFieldDefinition;
import org.mule.tooling.ui.contribution.debugger.controller.ScriptEvaluationDebuggerCallback;
import org.mule.tooling.ui.contribution.debugger.controller.WatchesLabelProvider;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerDisconnectedHandler;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerResumedHandler;
import org.mule.tooling.ui.contribution.debugger.service.ExpressionWatchesService;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.IObjectFieldDefinitionEditor;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class WatchesController
extends AbstractObjectFieldDefinitionController {
    private ClearWatchesResultsHandler listener;

    public WatchesController(IObjectFieldDefinitionEditor definitionComposite, EventBus eventBus) {
        super(definitionComposite, eventBus);
    }

    @Override
    protected void bind() {
        super.bind();
        TreeViewer payloadTreeViewer = this.getPayloadTreeViewer();
        payloadTreeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new WatchesLabelProvider()));
        this.listener = new ClearWatchesResultsHandler();
        this.getEventBus().registerListener(DebuggerEventTypes.RESUMED, (IEventHandler)this.listener);
        this.getEventBus().registerListener(DebuggerEventTypes.DISCONNECTED, (IEventHandler)this.listener);
    }

    @Override
    protected void populateData(MuleMessageInfo muleMessageInfo, ObjectFieldDefinition exceptionThrown) {
        TreeViewer treeViewer = this.getPayloadTreeViewer();
        TreeNode[] rootNodes = (TreeNode[])treeViewer.getInput();
        if (rootNodes != null) {
            TreeNode[] treeNodeArray = rootNodes;
            int n = rootNodes.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode node = treeNodeArray[n2];
                ObjectFieldDefinition def = (ObjectFieldDefinition)node.getValue();
                if (this.isExpressionFieldDefinition(def)) {
                    String script = def.getName();
                    MuleDebuggerService service = MuleDebuggerService.getDefault();
                    service.getDebuggerClient().executeScript("#[" + script + "]", service.getCurrentMuleMessageInfoId(), (IDebuggerResponseCallback)new ScriptEvaluationDebuggerCallback(node, (ColumnViewer)treeViewer));
                }
                ++n2;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getEventBus().unRegisterListener(DebuggerEventTypes.RESUMED, (IEventHandler)this.listener);
        this.getEventBus().unRegisterListener(DebuggerEventTypes.DISCONNECTED, (IEventHandler)this.listener);
    }

    public void addExpressionWatch(String expression) {
        ExpressionFieldDefinition definition = new ExpressionFieldDefinition(expression);
        this.getWatchesService().createMarker(definition);
        this.doAddExpressionWatch(definition);
    }

    public void addExpressionWatchFromMarker(ExpressionFieldDefinition expressionFieldDefinition) {
        this.doAddExpressionWatch(expressionFieldDefinition);
    }

    private void doAddExpressionWatch(ExpressionFieldDefinition expressionFieldDefinition) {
        TreeViewer payloadTreeViewer = this.getPayloadTreeViewer();
        TreeNode[] treeNodes = (TreeNode[])payloadTreeViewer.getInput();
        TreeNode node = new TreeNode((Object)expressionFieldDefinition);
        TreeNode[] newTreeNodes = this.createNewTreeNodes(treeNodes, node);
        payloadTreeViewer.setInput((Object)newTreeNodes);
        MuleDebuggerService debuggerService = MuleDebuggerService.getDefault();
        if (debuggerService.isDebugging()) {
            debuggerService.getDebuggerClient().executeScript(expressionFieldDefinition.getName(), debuggerService.getCurrentMuleMessageInfoId(), (IDebuggerResponseCallback)new ScriptEvaluationDebuggerCallback(node, (ColumnViewer)payloadTreeViewer));
        }
    }

    private TreeNode[] createNewTreeNodes(TreeNode[] treeNodes, TreeNode node) {
        if (treeNodes != null) {
            TreeNode[] newTreeNodes = Arrays.copyOf(treeNodes, treeNodes.length + 1);
            newTreeNodes[newTreeNodes.length - 1] = node;
            return newTreeNodes;
        }
        return new TreeNode[]{node};
    }

    public void removeExpressionWatch(TreeNode node) {
        this.getWatchesService().deleteMarker((ExpressionFieldDefinition)((Object)node.getValue()));
        this.doRemoveExpressionWatch(node);
    }

    private void doRemoveExpressionWatch(TreeNode node) {
        TreeNode[] treeNodes = (TreeNode[])this.getPayloadTreeViewer().getInput();
        TreeNode[] newTreeNodes = new TreeNode[treeNodes.length - 1];
        int j = 0;
        int i = 0;
        while (i < treeNodes.length) {
            if (treeNodes[i] != node) {
                newTreeNodes[j] = treeNodes[i];
                ++j;
            }
            ++i;
        }
        this.getPayloadTreeViewer().setInput((Object)newTreeNodes);
    }

    public void removeAllExpressionWatches() {
        ArrayList<TreeNode> definitionsToKeep = new ArrayList<TreeNode>();
        TreeNode[] rootNodes = (TreeNode[])this.getPayloadTreeViewer().getInput();
        if (rootNodes != null) {
            TreeNode[] treeNodeArray = rootNodes;
            int n = rootNodes.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode node = treeNodeArray[n2];
                ObjectFieldDefinition def = (ObjectFieldDefinition)node.getValue();
                if (this.isExpressionFieldDefinition(def)) {
                    this.getWatchesService().deleteMarker((ExpressionFieldDefinition)def);
                } else {
                    definitionsToKeep.add(node);
                }
                ++n2;
            }
        }
        this.getPayloadTreeViewer().setInput((Object)definitionsToKeep.toArray(new TreeNode[0]));
    }

    private TreeViewer getPayloadTreeViewer() {
        return this.getEditor().getPayloadTreeViewer();
    }

    private ExpressionWatchesService getWatchesService() {
        return MuleDebuggerService.getDefault().getExpressionWacthesService();
    }

    private boolean isExpressionFieldDefinition(ObjectFieldDefinition definition) {
        return definition instanceof ExpressionFieldDefinition;
    }

    private class ClearWatchesResultsHandler
    implements IDebuggerResumedHandler,
    IDebuggerDisconnectedHandler {
        private ClearWatchesResultsHandler() {
        }

        private void clearWatchesResults() {
            Display.getDefault().asyncExec(() -> {
                TreeNode[] rootNodes = (TreeNode[])WatchesController.this.getEditor().getPayloadTreeViewer().getInput();
                if (rootNodes != null) {
                    TreeNode[] treeNodeArray = rootNodes;
                    int n = rootNodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeNode node = treeNodeArray[n2];
                        this.clearWatchNode(node);
                        ++n2;
                    }
                    WatchesController.this.getEditor().getPayloadTreeViewer().refresh();
                }
            });
        }

        private void clearWatchNode(TreeNode node) {
            ObjectFieldDefinition def = (ObjectFieldDefinition)node.getValue();
            if (WatchesController.this.isExpressionFieldDefinition(def)) {
                ExpressionFieldDefinition fieldDefinition = (ExpressionFieldDefinition)((Object)node.getValue());
                fieldDefinition.setClassName(null);
                fieldDefinition.setValue(null);
                fieldDefinition.setInnerElements(Collections.emptyList());
                node.setChildren(null);
            }
        }

        @Override
        public void onDisconnected() {
            this.clearWatchesResults();
        }

        @Override
        public void onDebuggerResume() {
            this.clearWatchesResults();
        }
    }
}

