/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.controller;

import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.contribution.debugger.controller.ExpressionFieldDefinition;
import org.mule.tooling.ui.contribution.debugger.preferences.DebuggerPreferences;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerImages;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerWidgetsBuilder;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class TreeNodeLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public static final Set<String> PRIMITIVE_JDK_CLASSES_TO_BE_SHOWN = new HashSet<String>(Arrays.asList(Boolean.class.getCanonicalName(), Character.class.getCanonicalName(), Byte.class.getCanonicalName(), Short.class.getCanonicalName(), Integer.class.getCanonicalName(), Long.class.getCanonicalName(), Float.class.getCanonicalName(), Double.class.getCanonicalName(), String.class.getCanonicalName()));
    private static final Set<String> IGNORED_RUNTIME_CLASSES_TO_BE_SHOWN = new HashSet<String>(Arrays.asList("org.mule.runtime.core.internal.streaming.bytes.ManagedCursorStreamProvider", "org.mule.runtime.core.internal.streaming.object.ManagedCursorIteratorProvider", "org.mule.weave.v2.el.ByteArrayBasedCursorStreamProvider"));
    private static final DebuggerStyledStringStyler STYLE_STRING = new DebuggerStyledStringStyler(ThemeUtils.getCurrentTheme().getDebuggerStringColor());
    private static final DebuggerStyledStringStyler STYLE_BOLD = new DebuggerStyledStringStyler(Display.getCurrent().getSystemColor(10));
    private static final DebuggerStyledStringStyler STYLE_SEPARATOR = new DebuggerStyledStringStyler(Display.getCurrent().getSystemColor(15));
    private static final DebuggerStyledStringStyler STYLE_FULLY_QUALIFIED_NAME_CLASS = new DebuggerStyledStringStyler(Display.getCurrent().getSystemColor(16));
    private static final DebuggerStyledStringStyler STYLE_VAR_NAME = new DebuggerStyledStringStyler(ThemeUtils.getCurrentTheme().getDebuggerVarNameColor());
    private static final ErrorDebuggerStyledStringStyler ERROR_STYLE_VAR_NAME = new ErrorDebuggerStyledStringStyler(Display.getCurrent().getSystemColor(4), Display.getCurrent().getSystemColor(3));
    private static final DebuggerStyledStringStyler STYLE_DEFAULT = new DebuggerStyledStringStyler(ThemeUtils.getCurrentTheme().getDebuggerDefaultColor());

    public Image getImage(Object element) {
        TreeNode node = (TreeNode)element;
        ObjectFieldDefinition value = (ObjectFieldDefinition)node.getValue();
        DebuggerImages debuggerImages = DebuggerImages.getDebuggerImages();
        if (value instanceof ExpressionFieldDefinition) {
            return debuggerImages.getImageDescriptor("icons/small/expression.png").createImage();
        }
        return value.getInnerElements().isEmpty() && !value.isHasUnloadedChildren() ? debuggerImages.getImage("Java_Attr") : debuggerImages.getImage("Java_Element");
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public StyledString getStyledText(Object element) {
        TreeNode node = (TreeNode)element;
        ObjectFieldDefinition def = (ObjectFieldDefinition)node.getValue();
        boolean isErrorDefinition = def.getPath() != null && ("SYNTHETIC_OPERATION_ERROR_ROOT".equals(def.getPath().getRootExpression()) || "SYNTHETIC_ERROR_ROOT_ELEMENT".equals(def.getPath().getRootExpression()));
        StyledString text = new StyledString();
        text.append(def.getName(), this.getStyleVarName(isErrorDefinition));
        text.append(" = ", (StyledString.Styler)STYLE_SEPARATOR);
        this.addStyledTextToClass(def, text);
        String trimmedValue = DebuggerWidgetsBuilder.trimIfNeccesary(def.getValue());
        if (this.isString(def.getClassName())) {
            text.append(DebuggerWidgetsBuilder.getQuotedString(trimmedValue, (Boolean)false), (StyledString.Styler)STYLE_STRING);
        } else if (this.isBoolean(def.getClassName())) {
            text.append(trimmedValue, (StyledString.Styler)STYLE_BOLD);
        } else {
            text.append(trimmedValue, (StyledString.Styler)STYLE_DEFAULT);
        }
        return text;
    }

    private void addStyledTextToClass(ObjectFieldDefinition def, StyledString text) {
        String className = def.getClassName();
        if (StringUtils.isNotBlank((String)className) && DebuggerPreferences.showJavaClasses() && this.shouldBeShown(className)) {
            if (DebuggerPreferences.showJavaClassesMostSignificativePart() && className.contains(".")) {
                className = className.substring(className.lastIndexOf(46) + 1, className.length());
            }
            text.append("{" + className + "}", (StyledString.Styler)STYLE_FULLY_QUALIFIED_NAME_CLASS);
            text.append(" ");
        }
    }

    private StyledString.Styler getStyleVarName(boolean error) {
        return error ? ERROR_STYLE_VAR_NAME : STYLE_VAR_NAME;
    }

    private boolean isString(String className) {
        return String.class.getCanonicalName().equals(className);
    }

    private boolean isBoolean(String className) {
        return Boolean.class.getCanonicalName().equals(className);
    }

    private boolean shouldBeShown(String className) {
        boolean result = PRIMITIVE_JDK_CLASSES_TO_BE_SHOWN.contains(className) ? DebuggerPreferences.showJavaPrimitiveClasses() : !IGNORED_RUNTIME_CLASSES_TO_BE_SHOWN.contains(className);
        return result;
    }

    private static class DebuggerStyledStringStyler
    extends StyledString.Styler {
        final Color foreground;

        public DebuggerStyledStringStyler(Color foreground) {
            this.foreground = foreground;
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = this.foreground;
        }
    }

    private static final class ErrorDebuggerStyledStringStyler
    extends DebuggerStyledStringStyler {
        final Color background;

        public ErrorDebuggerStyledStringStyler(Color foreground, Color background) {
            super(foreground);
            this.background = background;
        }

        @Override
        public void applyStyles(TextStyle textStyle) {
            super.applyStyles(textStyle);
            textStyle.underline = true;
            textStyle.underlineStyle = 2;
            textStyle.underlineColor = this.background;
        }
    }
}

