/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.controller;

import com.mulesoft.mule.debugger.dto.MuleMessageInfo;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.dto.ScriptResultInfo;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.response.callback.DefaultDebuggerResponseCallback;
import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.contribution.debugger.controller.AbstractObjectFieldDefinitionController;
import org.mule.tooling.ui.contribution.debugger.controller.ObjectTreeNodeBuilder;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.IScriptEvaluationEditor;
import org.mule.tooling.utils.eventbus.EventBus;

public class ScriptEvaluationController {
    private IScriptEvaluationEditor scriptEvaluation;
    private EventBus eventBus;

    public ScriptEvaluationController(IScriptEvaluationEditor scriptEvaluation, EventBus eventBus) {
        this.scriptEvaluation = scriptEvaluation;
        this.eventBus = eventBus;
        this.bind();
    }

    protected void bind() {
        new AbstractObjectFieldDefinitionController(this.scriptEvaluation.getResult(), this.eventBus){

            @Override
            protected void populateData(MuleMessageInfo muleMessageInfo, ObjectFieldDefinition exceptionThrown) {
            }
        };
        this.scriptEvaluation.getExpressionControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' || e.character == '\n') {
                    MuleDebuggerService service = MuleDebuggerService.getDefault();
                    service.getDebuggerClient().executeScript("#[" + ScriptEvaluationController.this.scriptEvaluation.getScriptText() + "]", service.getCurrentMuleMessageInfoId(), (IDebuggerResponseCallback)new ScriptEvaluationDebuggerCallback());
                }
            }
        });
    }

    private final class ScriptEvaluationDebuggerCallback
    extends DefaultDebuggerResponseCallback {
        private ScriptEvaluationDebuggerCallback() {
        }

        public void onScriptEvaluation(ScriptResultInfo info) {
            Display.getDefault().asyncExec(() -> {
                ObjectFieldDefinition excResultDef = info.getResult();
                ScriptEvaluationController.this.scriptEvaluation.getResult().getPayloadTreeViewer().setInput((Object)new TreeNode[]{ObjectTreeNodeBuilder.createTreeNode(excResultDef)});
            });
        }

        public void onScriptEvaluationException(RemoteDebugException exception) {
            Display.getDefault().asyncExec(() -> {
                ObjectFieldDefinition excResultDef = exception.getException();
                ScriptEvaluationController.this.scriptEvaluation.getResult().getPayloadTreeViewer().setInput((Object)new TreeNode[]{ObjectTreeNodeBuilder.createTreeNode(excResultDef)});
            });
        }
    }
}

