/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.controller;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerWidgetsBuilder;
import org.mule.tooling.ui.contribution.debugger.view.impl.ScriptEditorComposite;
import org.mule.tooling.ui.widgets.text.History;

public class ScriptEditorController {
    private ScriptEditorComposite scriptEditorComposite;
    private ToolItem toolItemComposite;
    private History history;
    private SelectionListener toolItemListener;

    public ScriptEditorController(History history, ToolItem composite, ScriptEditorComposite scriptEditorComposite) {
        this.scriptEditorComposite = scriptEditorComposite;
        this.toolItemComposite = composite;
        this.history = history;
        this.bind();
    }

    private void bind() {
        this.toolItemListener = SelectionListener.widgetSelectedAdapter(event -> this.setHistoryItems(this.toolItemComposite, (SelectionEvent)event));
        this.toolItemComposite.addSelectionListener(this.toolItemListener);
    }

    public void dispose() {
        this.toolItemComposite.removeSelectionListener(this.toolItemListener);
    }

    private void setHistoryItems(ToolItem composite, SelectionEvent e) {
        MenuManager menuManager = null;
        if (menuManager == null) {
            menuManager = new MenuManager();
            String[] stringArray = this.history.getReversedHistory();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                String trimmedValue = DebuggerWidgetsBuilder.trimIfNeccesary(item);
                String quotedValue = DebuggerWidgetsBuilder.getQuotedString(trimmedValue, (Boolean)false);
                HistoryAction action = new HistoryAction(quotedValue, item);
                menuManager.add((IAction)action);
                ++n2;
            }
        }
        Menu menu = menuManager.createContextMenu((Control)composite.getParent().getShell());
        ToolItem item = (ToolItem)e.widget;
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }

    private class HistoryAction
    extends Action {
        private String value;

        public HistoryAction(String title, String value) {
            super(title, 1);
            this.value = value;
        }

        public void run() {
            ScriptEditorController.this.scriptEditorComposite.getEditor().setTextDocument(this.value);
        }
    }
}

