/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.controller;

import com.mulesoft.mule.debugger.client.IDebuggerClient;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.response.callback.DefaultDebuggerResponseCallback;
import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.viewers.TreeNode;
import org.mule.tooling.ui.contribution.debugger.controller.ExpressionFieldDefinition;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;

public class ObjectTreeNodeBuilder {
    public static TreeNode[] createTreeNode(Collection<ObjectFieldDefinition> objects) {
        Collection<ObjectFieldDefinition> filteredCollection = ObjectTreeNodeBuilder.getCollectionWithoutNulls(objects);
        TreeNode[] result = new TreeNode[filteredCollection.size()];
        int i = 0;
        for (ObjectFieldDefinition objectFieldDefinition : filteredCollection) {
            result[i] = ObjectTreeNodeBuilder.createTreeNode(objectFieldDefinition);
            ++i;
        }
        return result;
    }

    public static TreeNode[] createChildrenNodes(TreeNode parent) {
        ObjectFieldDefinition value = (ObjectFieldDefinition)parent.getValue();
        ArrayList<ObjectFieldDefinition> innerElements = value.getInnerElements();
        if (!(value instanceof ExpressionFieldDefinition) && (innerElements == null || innerElements.isEmpty())) {
            innerElements = new ArrayList<ObjectFieldDefinition>();
            MuleDebuggerService service = MuleDebuggerService.getDefault();
            IDebuggerClient debuggerClient = service.getDebuggerClient();
            CountDownLatch callbackReturnSignal = new CountDownLatch(1);
            debuggerClient.loadInnerFields(value.getPath(), service.getCurrentMuleMessageInfoId(), (IDebuggerResponseCallback)new LoadInnerFieldsCallback(innerElements, callbackReturnSignal));
            try {
                callbackReturnSignal.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return ObjectTreeNodeBuilder.doCreateChildrenNodes(parent, innerElements);
        }
        return ObjectTreeNodeBuilder.doCreateChildrenNodes(parent, (List<ObjectFieldDefinition>)innerElements);
    }

    private static TreeNode[] doCreateChildrenNodes(TreeNode parent, List<ObjectFieldDefinition> innerElements) {
        TreeNode[] children = new TreeNode[innerElements.size()];
        int i = 0;
        for (ObjectFieldDefinition objectFieldDef : innerElements) {
            children[i] = ObjectTreeNodeBuilder.createTreeNode(objectFieldDef);
            children[i].setParent(parent);
            ++i;
        }
        parent.setChildren(children);
        return children;
    }

    public static TreeNode createTreeNode(ObjectFieldDefinition object) {
        if (object == null) {
            throw new IllegalArgumentException("The value for the tree node can't be null");
        }
        return new TreeNode((Object)object);
    }

    private static Collection<ObjectFieldDefinition> getCollectionWithoutNulls(Collection<ObjectFieldDefinition> objects) {
        ArrayList<ObjectFieldDefinition> filteredList = new ArrayList<ObjectFieldDefinition>();
        for (ObjectFieldDefinition objectFieldDefinition : objects) {
            if (objectFieldDefinition == null) continue;
            filteredList.add(objectFieldDefinition);
        }
        return filteredList;
    }

    public static class LoadInnerFieldsCallback
    extends DefaultDebuggerResponseCallback {
        private List<ObjectFieldDefinition> listToFill;
        private CountDownLatch callbackReturnSignal;

        public LoadInnerFieldsCallback(List<ObjectFieldDefinition> listToFill, CountDownLatch callbackReturnSignal) {
            this.listToFill = listToFill;
            this.callbackReturnSignal = callbackReturnSignal;
        }

        public void onInnerFieldsLoaded(ObjectFieldDefinition innerFields) {
            this.listToFill.addAll(innerFields.getInnerElements());
            this.callbackReturnSignal.countDown();
        }
    }
}

