/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.controller;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerEventTypes;
import org.mule.tooling.ui.contribution.debugger.view.IMuleDebuggerEditor;
import org.mule.tooling.utils.eventbus.EventBus;

public class MuleDebuggerViewController {
    private IMuleDebuggerEditor editor;
    private EventBus eventBus;

    public MuleDebuggerViewController(IMuleDebuggerEditor editor, EventBus eventBus) {
        this.editor = editor;
        this.eventBus = eventBus;
        this.bind();
    }

    protected void bind() {
        this.editor.setDebuggerConnected(false);
        this.eventBus.registerListener(DebuggerEventTypes.CONNECTED, () -> Display.getDefault().syncExec(() -> this.editor.setDebuggerConnected(true)));
        this.eventBus.registerListener(DebuggerEventTypes.DISCONNECTED, () -> Display.getDefault().syncExec(() -> this.editor.setDebuggerConnected(false)));
        this.eventBus.registerListener(DebuggerEventTypes.RESUMED, () -> Display.getDefault().syncExec(() -> this.editor.setDebuggerResumed(true)));
        this.eventBus.registerListener(DebuggerEventTypes.EXCEPTION, exception -> Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Remote Error", (String)exception.getMessage())));
        this.eventBus.registerListener(DebuggerEventTypes.MULE_MESSAGE_ARRIVED, (muleMessageInfo, exceptionThrown) -> Display.getDefault().syncExec(() -> this.editor.setDebuggerResumed(false)));
    }
}

