/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.controller;

import com.mulesoft.mule.debugger.dto.MessageProcessorInfo;
import com.mulesoft.mule.debugger.dto.MuleMessageInfo;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.ui.contribution.debugger.controller.AbstractObjectFieldDefinitionController;
import org.mule.tooling.ui.contribution.debugger.controller.CurrentOperationFieldDefinition;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerEventTypes;
import org.mule.tooling.ui.contribution.debugger.controller.ExpressionFieldDefinition;
import org.mule.tooling.ui.contribution.debugger.controller.ObjectTreeNodeBuilder;
import org.mule.tooling.ui.contribution.debugger.controller.TreeNodeLabelProvider;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerDisconnectedHandler;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerNextStepHandler;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerResumedHandler;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerRunToProcessorHandler;
import org.mule.tooling.ui.contribution.debugger.decorator.DebuggerHighlighter;
import org.mule.tooling.ui.contribution.debugger.utils.FlowEditorEntityEditPartPair;
import org.mule.tooling.ui.contribution.debugger.utils.MuleDebuggerUtils;
import org.mule.tooling.ui.contribution.debugger.view.IObjectFieldDefinitionEditor;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MuleDebuggerMuleMessageController
extends AbstractObjectFieldDefinitionController {
    public static final String CURRENT_OPERATION_MARKER = "SYNTHETIC_ROOT_ELEMENT";
    public static final String CURRENT_ERROR_OPERATION_MARKER = "SYNTHETIC_ERROR_ROOT_ELEMENT";
    private RestoreLastHighlightedOnEventHandler restoreHighlightedListener = new RestoreLastHighlightedOnEventHandler();
    private ClearMuleMessagesListener clearMuleMessagesListener;

    public MuleDebuggerMuleMessageController(IObjectFieldDefinitionEditor editor, EventBus eventBus) {
        super(editor, eventBus);
        eventBus.registerListener(DebuggerEventTypes.RESUMED, (IEventHandler)this.restoreHighlightedListener);
        eventBus.registerListener(DebuggerEventTypes.RUN_TO_PROCESSOR, (IEventHandler)this.restoreHighlightedListener);
        eventBus.registerListener(DebuggerEventTypes.NEXT_STEP, (IEventHandler)this.restoreHighlightedListener);
        eventBus.registerListener(DebuggerEventTypes.DISCONNECTED, (IEventHandler)this.restoreHighlightedListener);
        this.clearMuleMessagesListener = new ClearMuleMessagesListener();
        eventBus.registerListener(DebuggerEventTypes.RESUMED, (IEventHandler)this.clearMuleMessagesListener);
        eventBus.registerListener(DebuggerEventTypes.DISCONNECTED, (IEventHandler)this.clearMuleMessagesListener);
    }

    @Override
    protected void populateData(MuleMessageInfo muleMessageInfo, ObjectFieldDefinition exceptionThrown) {
        MessageProcessorInfo messageProcessorInfo = muleMessageInfo.getMessageProcessorInfo();
        String path = messageProcessorInfo.getPath();
        String projectName = muleMessageInfo.getAppName();
        String studioPath = MessageFlowUtils.mulePathToStudioPath((String)path);
        FlowEditorEntityEditPartPair pair = MuleDebuggerUtils.findEditPartAndFlowEditor(projectName, studioPath, true);
        EntityEditPart<?> editPartFromPath = pair.getEditPart();
        ObjectFieldDefinition currentOperationDefinition = this.createCurrentOperationDefinition(messageProcessorInfo, projectName);
        if (editPartFromPath != null) {
            pair.getEditor().getFlowEditor().getViewer().reveal(editPartFromPath);
            editPartFromPath.showCollapsed();
            Color highlightColor = exceptionThrown == null ? ThemeUtils.getCurrentTheme().getDebuggerHighlightColor() : ThemeUtils.getCurrentTheme().getDebuggerErrorHighlightColor();
            DebuggerHighlighter.getInstance().highlight(studioPath, editPartFromPath.getFigure(), highlightColor);
            if (editPartFromPath.getEntity() instanceof MessageFlowNode) {
                MessageFlowNode node = (MessageFlowNode)editPartFromPath.getEntity();
                Image iconImage = node.getDefinition().getIconImage();
                this.getPayloadTreeViewer().setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new CurrentOperationTreeNodeLabelProvider(iconImage, currentOperationDefinition)));
            }
        }
        TreeViewer treeViewer = this.getEditor().getPayloadTreeViewer();
        List definitions = muleMessageInfo.getDefinitions();
        definitions.add(currentOperationDefinition);
        definitions.addAll(this.getExpressionDefinitions(treeViewer));
        this.getPayloadTreeViewer().setInput((Object)ObjectTreeNodeBuilder.createTreeNode(definitions));
        Optional<ObjectFieldDefinition> maybeErrorDefinition = definitions.stream().filter(def -> "error".equals(def.getName())).findFirst();
        maybeErrorDefinition.ifPresent(this::expandDefinition);
        maybeErrorDefinition.ifPresent(this::focusErrorDescription);
    }

    private List<ObjectFieldDefinition> getExpressionDefinitions(TreeViewer treeViewer) {
        return this.getExpressionNodes(treeViewer).stream().map(n -> (ObjectFieldDefinition)n.getValue()).collect(Collectors.toList());
    }

    private List<TreeNode> getExpressionNodes(TreeViewer treeViewer) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        TreeNode[] rootNodes = (TreeNode[])treeViewer.getInput();
        if (rootNodes != null) {
            TreeNode[] treeNodeArray = rootNodes;
            int n = rootNodes.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode node = treeNodeArray[n2];
                ObjectFieldDefinition def = (ObjectFieldDefinition)node.getValue();
                if (def instanceof ExpressionFieldDefinition) {
                    list.add(node);
                }
                ++n2;
            }
        }
        return list;
    }

    private TreeViewer getPayloadTreeViewer() {
        return this.getEditor().getPayloadTreeViewer();
    }

    private void focusErrorDescription(ObjectFieldDefinition def) {
        if (def.getInnerElements() == null) {
            return;
        }
        def.getInnerElements().stream().filter(element -> "detailedDescription".equals(element.getName())).findFirst().ifPresent(this::setSelection);
    }

    private void setSelection(ObjectFieldDefinition def) {
        this.getPayloadTreeViewer().setSelection((ISelection)new StructuredSelection((Object)ObjectTreeNodeBuilder.createTreeNode(def)), true);
    }

    private void expandDefinition(ObjectFieldDefinition def) {
        this.getPayloadTreeViewer().expandToLevel((Object)ObjectTreeNodeBuilder.createTreeNode(def), 1);
    }

    private ObjectFieldDefinition createCurrentOperationDefinition(MessageProcessorInfo messageProcessorInfo, String projectName) {
        String rootExpression;
        List<ObjectFieldDefinition> innerElements = messageProcessorInfo.getFields().stream().filter(def -> !def.getName().startsWith("doc:")).collect(Collectors.toList());
        String name = StringUtils.isBlank((String)messageProcessorInfo.getIdentifier()) ? "Current operation" : WordUtils.capitalize((String)messageProcessorInfo.getIdentifier().replaceAll("-", " "));
        long errors = messageProcessorInfo.getFields().stream().filter(def -> "SYNTHETIC_OPERATION_ERROR_ROOT".equals(def.getPath().getRootExpression())).count();
        Object value = messageProcessorInfo.getFields().stream().filter(def -> def.getName().equals("doc:name")).map(ObjectFieldDefinition::getValue).findFirst().orElse("");
        if (errors == 0L) {
            rootExpression = CURRENT_OPERATION_MARKER;
        } else {
            rootExpression = CURRENT_ERROR_OPERATION_MARKER;
            value = (String)value + (String)(errors == 1L ? " (there is a field with an expression error)" : " (there are " + errors + " fields with expression errors)");
        }
        return new CurrentOperationFieldDefinition(name, (String)value, innerElements, rootExpression, messageProcessorInfo.getPath(), projectName);
    }

    @Override
    public void dispose() {
        this.getEventBus().unRegisterListener(DebuggerEventTypes.RESUMED, (IEventHandler)this.restoreHighlightedListener);
        this.getEventBus().unRegisterListener(DebuggerEventTypes.DISCONNECTED, (IEventHandler)this.restoreHighlightedListener);
        this.getEventBus().unRegisterListener(DebuggerEventTypes.RUN_TO_PROCESSOR, (IEventHandler)this.restoreHighlightedListener);
        this.getEventBus().unRegisterListener(DebuggerEventTypes.NEXT_STEP, (IEventHandler)this.restoreHighlightedListener);
        this.getEventBus().unRegisterListener(DebuggerEventTypes.RESUMED, (IEventHandler)this.clearMuleMessagesListener);
        this.getEventBus().unRegisterListener(DebuggerEventTypes.DISCONNECTED, (IEventHandler)this.clearMuleMessagesListener);
    }

    public static boolean isSynthetic(ObjectFieldDefinition def) {
        String rootExpression;
        boolean result = def.getPath() == null ? false : CURRENT_OPERATION_MARKER.equals(rootExpression = def.getPath().getRootExpression()) || CURRENT_ERROR_OPERATION_MARKER.equals(rootExpression) || "SYNTHETIC_OPERATION_ROOT".equals(rootExpression) || "SYNTHETIC_OPERATION_ERROR_ROOT".equals(rootExpression);
        return result;
    }

    private class ClearMuleMessagesListener
    implements IDebuggerResumedHandler,
    IDebuggerDisconnectedHandler {
        private ClearMuleMessagesListener() {
        }

        private void clearMuleMessages() {
            Display.getDefault().asyncExec(() -> {
                List<TreeNode> definitionsToKeep = MuleDebuggerMuleMessageController.this.getExpressionNodes(MuleDebuggerMuleMessageController.this.getEditor().getPayloadTreeViewer());
                MuleDebuggerMuleMessageController.this.getEditor().getPayloadTreeViewer().setInput((Object)definitionsToKeep.toArray(new TreeNode[0]));
                MuleDebuggerMuleMessageController.this.getEditor().getPayloadTreeViewer().refresh();
            });
        }

        @Override
        public void onDisconnected() {
            this.clearMuleMessages();
        }

        @Override
        public void onDebuggerResume() {
            this.clearMuleMessages();
        }
    }

    private static class CurrentOperationTreeNodeLabelProvider
    extends TreeNodeLabelProvider {
        final Image iconImage;
        final ObjectFieldDefinition currentOperationDefinition;

        public CurrentOperationTreeNodeLabelProvider(Image iconImage, ObjectFieldDefinition currentOperationDefinition) {
            this.iconImage = iconImage;
            this.currentOperationDefinition = currentOperationDefinition;
        }

        @Override
        public Image getImage(Object element) {
            TreeNode node = (TreeNode)element;
            ObjectFieldDefinition value = (ObjectFieldDefinition)node.getValue();
            if (value.equals((Object)this.currentOperationDefinition)) {
                return this.iconImage;
            }
            return super.getImage(element);
        }
    }

    private final class RestoreLastHighlightedOnEventHandler
    implements IDebuggerResumedHandler,
    IDebuggerDisconnectedHandler,
    IDebuggerRunToProcessorHandler,
    IDebuggerNextStepHandler {
        private RestoreLastHighlightedOnEventHandler() {
        }

        @Override
        public void onDebuggerResume() {
            this.restoreLastHighlighted();
        }

        @Override
        public void onNextStep() {
            this.restoreLastHighlighted();
        }

        @Override
        public void onRunToProcessor() {
            this.restoreLastHighlighted();
        }

        @Override
        public void onDisconnected() {
            this.restoreLastHighlighted();
        }

        private void restoreLastHighlighted() {
            Display.getDefault().asyncExec(() -> DebuggerHighlighter.getInstance().restoreLastHighlighted());
        }
    }
}

