/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.controller;

import java.util.Observer;
import java.util.Optional;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PartInitException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerEventTypes;
import org.mule.tooling.ui.contribution.debugger.controller.events.IDebuggerMuteBreakpoints;
import org.mule.tooling.ui.contribution.debugger.service.BreakpointDefinition;
import org.mule.tooling.ui.contribution.debugger.service.MuleBreakpointService;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.utils.FlowEditorEntityEditPartPair;
import org.mule.tooling.ui.contribution.debugger.utils.MuleDebuggerUtils;
import org.mule.tooling.ui.contribution.debugger.view.IMuleBreakpointEditor;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MuleBreakpointsController {
    private IMuleBreakpointEditor editor;
    private EventBus eventBus;
    private Observer observer;
    private IDocumentListener listener;
    private IDebuggerMuteBreakpoints muteBreakpointsListener;

    public MuleBreakpointsController(IMuleBreakpointEditor editor, EventBus eventBus) {
        this.editor = editor;
        this.eventBus = eventBus;
        this.bind();
    }

    public void bind() {
        CheckboxTableViewer breakpointTable = this.editor.getBreakpointTable();
        breakpointTable.setLabelProvider((IBaseLabelProvider)new BreakpointLabelProvider());
        breakpointTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        final MuleBreakpointService breakpointService = MuleDebuggerService.getDefault().getBreakpointService();
        breakpointTable.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                BreakpointDefinition breakpointDefinition = (BreakpointDefinition)element;
                return breakpointDefinition.isEnabled();
            }

            public boolean isGrayed(Object element) {
                return breakpointService.isMuteBreakpoints();
            }
        });
        breakpointTable.setInput(breakpointService.getBreakpoints());
        this.observer = (arg0, arg1) -> breakpointTable.setInput(breakpointService.getBreakpoints());
        breakpointService.addObserver(this.observer);
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)breakpointTable.getTable(), 0)};
        breakpointTable.setCellEditors(editors);
        this.listener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (!MuleBreakpointsController.this.editor.getBreakpointTable().getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)MuleBreakpointsController.this.editor.getBreakpointTable().getSelection();
                    BreakpointDefinition breakpoint = (BreakpointDefinition)selection.getFirstElement();
                    breakpoint.setConditionScript(MuleBreakpointsController.this.editor.getConditionalScript().getEditor().getTextDocument());
                    EntityEditPart<?> editPart = MuleDebuggerUtils.findEditPartFromPathInOpenEditors(breakpoint.getAppName(), breakpoint.getPath(), false);
                    AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.CONDITIONAL_BREAKPOINT).addMetadata("script", breakpoint.getConditionScript()).withOptionalConnectorProperty(Optional.ofNullable(editPart.getEntity()), MuleCorePlugin.getDesignContext().getMuleProject()).track();
                }
            }
        };
        this.disableConditional();
        this.editor.getConditional().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection structuredSelection = (StructuredSelection)MuleBreakpointsController.this.editor.getBreakpointTable().getSelection();
                if (!structuredSelection.isEmpty()) {
                    BreakpointDefinition breakpoint = (BreakpointDefinition)structuredSelection.getFirstElement();
                    boolean selected = MuleBreakpointsController.this.editor.getConditional().getSelection();
                    breakpoint.setConditional(selected);
                    if (selected) {
                        MuleBreakpointsController.this.addConditionalScriptEditor(breakpoint.getConditionScript());
                    } else {
                        breakpoint.clearConditionScript();
                        MuleBreakpointsController.this.removeConditionalScriptEditor();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        breakpointTable.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection.isEmpty()) {
                this.disableConditional();
            } else {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                BreakpointDefinition breakpoint = (BreakpointDefinition)structuredSelection.getFirstElement();
                this.editor.getConditional().setEnabled(true);
                this.editor.getConditional().setSelection(breakpoint.isConditional());
                this.removeConditionalScriptEditor();
                if (breakpoint.isConditional()) {
                    this.addConditionalScriptEditor(breakpoint.getConditionScript());
                }
            }
        });
        breakpointTable.addCheckStateListener(event -> {
            MuleBreakpointService service = MuleDebuggerService.getDefault().getBreakpointService();
            boolean mutedBreakpoints = service.isMuteBreakpoints();
            BreakpointDefinition breakpoint = (BreakpointDefinition)event.getElement();
            breakpoint.setEnabled(event.getChecked());
            EntityEditPart<?> editPart = MuleDebuggerUtils.findEditPartFromPathInOpenEditors(breakpoint.getAppName(), breakpoint.getPath(), false);
            MessageFlowEntity entity = null;
            if (editPart != null) {
                editPart.updateFigure();
                entity = editPart.getEntity();
            }
            IMuleProject muleProject = null;
            IMuleProject[] iMuleProjectArray = MuleRuntime.getMuleProjects();
            int n = iMuleProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMuleProject p = iMuleProjectArray[n2];
                if (p.getName().equals(breakpoint.getAppName())) {
                    muleProject = p;
                    break;
                }
                ++n2;
            }
            Optional<Object> project = Optional.ofNullable(muleProject);
            if (!mutedBreakpoints) {
                if (event.getChecked()) {
                    AnalyticsRecordsFactory.single((String)DebugEvents.TOGGLE_BREAKPOINT, project).addMetadata("operation", "enable").addMetadata("from", "table").withOptionalConnectorProperty(Optional.ofNullable(entity), MuleCorePlugin.getDesignContext().getMuleProject()).track();
                    MuleDebuggerService.getDefault().getBreakpointService().enableBreakpoint(breakpoint);
                } else {
                    AnalyticsRecordsFactory.single((String)DebugEvents.TOGGLE_BREAKPOINT, project).addMetadata("operation", "disable").addMetadata("from", "table").withOptionalConnectorProperty(Optional.ofNullable(entity), MuleCorePlugin.getDesignContext().getMuleProject()).track();
                    MuleDebuggerService.getDefault().getBreakpointService().disableBreakpoint(breakpoint);
                }
            }
        });
        breakpointTable.addOpenListener(event -> {
            StructuredSelection structuredSelection = (StructuredSelection)event.getSelection();
            BreakpointDefinition breakpoint = (BreakpointDefinition)structuredSelection.getFirstElement();
            FlowEditorEntityEditPartPair pair = MuleDebuggerUtils.findEditPartAndFlowEditor(breakpoint.getAppName(), breakpoint.getPath(), false);
            MultiPageMessageFlowEditor multiPageFlowEditor = pair.getEditor();
            EntityEditPart<?> editPart = pair.getEditPart();
            if (multiPageFlowEditor != null) {
                try {
                    multiPageFlowEditor.openEditor();
                }
                catch (PartInitException e) {
                    throw new RuntimeException("Couldn't open the multi page message flow editor", e);
                }
                if (multiPageFlowEditor.getCurentPageIndex() != multiPageFlowEditor.getFlowEditorIndex()) {
                    multiPageFlowEditor.openFlowEditorPage();
                }
                multiPageFlowEditor.getFlowEditor().getViewer().reveal(editPart);
                EntityEditPart<?> editPartFromPath = MuleDebuggerUtils.findEditPartAndFlowEditor(breakpoint.getAppName(), breakpoint.getPath(), false).getEditPart();
                multiPageFlowEditor.getFlowEditor().setSelection((ISelection)new StructuredSelection(editPartFromPath));
            }
        });
        this.muteBreakpointsListener = () -> {
            if (!this.editor.getBreakpointTable().getTable().isDisposed()) {
                this.editor.getBreakpointTable().refresh();
            }
        };
        this.eventBus.registerListener(DebuggerEventTypes.MUTE_BREAKPOINTS, (IEventHandler)this.muteBreakpointsListener);
    }

    private void addConditionalScriptEditor(String script) {
        DFLEmbeddedEditor scriptEditor = this.editor.createConditionalScript().getEditor();
        scriptEditor.setTextDocument(script);
        scriptEditor.getDocument().addDocumentListener(this.listener);
    }

    private void removeConditionalScriptEditor() {
        if (this.editor.getConditionalScript() != null) {
            this.editor.getConditionalScript().getEditor().getDocument().removeDocumentListener(this.listener);
            this.editor.removeConditionalScript();
        }
    }

    public void disableConditional() {
        this.editor.getConditional().setEnabled(false);
        this.removeConditionalScriptEditor();
    }

    public void dispose() {
        MuleBreakpointService breakpointService = MuleDebuggerService.getDefault().getBreakpointService();
        breakpointService.deleteObserver(this.observer);
        this.removeConditionalScriptEditor();
        this.eventBus.unRegisterListener(DebuggerEventTypes.MUTE_BREAKPOINTS, (IEventHandler)this.muteBreakpointsListener);
    }

    private static class BreakpointLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private BreakpointLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            BreakpointDefinition breakpointDefinition = (BreakpointDefinition)element;
            if (breakpointDefinition.getIconPath() == null) {
                this.setIconPath(breakpointDefinition);
            }
            return breakpointDefinition.getIconImage();
        }

        private void setIconPath(BreakpointDefinition breakpointDefinition) {
            EntityEditPart<?> editPartFromPath = MuleDebuggerUtils.findEditPartAndFlowEditor(breakpointDefinition.getAppName(), breakpointDefinition.getPath(), false).getEditPart();
            if (editPartFromPath != null) {
                IMessageFlowNode node = (IMessageFlowNode)editPartFromPath.getEntity();
                breakpointDefinition.setIconPath(node.getDefinition().getIconPath());
            }
        }

        public String getColumnText(Object element, int columnIndex) {
            BreakpointDefinition breakpointDefinition = (BreakpointDefinition)element;
            return this.getStringToShow(breakpointDefinition);
        }

        private String getStringToShow(BreakpointDefinition breakpointDefinition) {
            return breakpointDefinition.toString();
        }
    }
}

