/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.controller;

import com.mulesoft.mule.debugger.dto.MuleMessageInfo;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.dto.ScriptResultInfo;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.response.callback.DefaultDebuggerResponseCallback;
import org.mule.tooling.ui.contribution.debugger.controller.events.ConnectedEvent;
import org.mule.tooling.ui.contribution.debugger.controller.events.DebuggerErrorEvent;
import org.mule.tooling.ui.contribution.debugger.controller.events.DebuggerExceptionEvent;
import org.mule.tooling.ui.contribution.debugger.controller.events.DisconnectedEvent;
import org.mule.tooling.ui.contribution.debugger.controller.events.FieldUpdatedEvent;
import org.mule.tooling.ui.contribution.debugger.controller.events.NewMuleMessageArrivedEvent;
import org.mule.tooling.ui.contribution.debugger.controller.events.NextStepExecutedEvent;
import org.mule.tooling.ui.contribution.debugger.controller.events.ResumeEvent;
import org.mule.tooling.ui.contribution.debugger.controller.events.RunToProcessorExecutedEvent;
import org.mule.tooling.ui.contribution.debugger.controller.events.ScriptEvaluatedEvent;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class DebuggerResponseCallback
extends DefaultDebuggerResponseCallback {
    private EventBus eventBus;

    public DebuggerResponseCallback(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void onConnected() {
        this.eventBus.fireEvent((IEvent)new ConnectedEvent());
    }

    public void onError(String errorMessage) {
        this.eventBus.fireEvent((IEvent)new DebuggerErrorEvent(errorMessage));
    }

    public void onExit() {
        this.eventBus.fireEvent((IEvent)new DisconnectedEvent());
    }

    public void onMuleMessageArrived(MuleMessageInfo muleMessageInfo) {
        this.eventBus.fireEvent((IEvent)new NewMuleMessageArrivedEvent(muleMessageInfo));
    }

    public void onScriptEvaluation(ScriptResultInfo scriptResult) {
        this.eventBus.fireEvent((IEvent)new ScriptEvaluatedEvent(scriptResult));
    }

    public void onResume() {
        this.eventBus.fireEvent((IEvent)new ResumeEvent());
    }

    public void onExceptionThrown(MuleMessageInfo muleMessageInfo, ObjectFieldDefinition exceptionThrown) {
        this.eventBus.fireEvent((IEvent)new NewMuleMessageArrivedEvent(muleMessageInfo, exceptionThrown));
    }

    public void onScriptEvaluationException(RemoteDebugException exception) {
        this.eventBus.fireEvent((IEvent)new DebuggerExceptionEvent(exception));
    }

    public void onFieldUpdated(ObjectFieldDefinition payload) {
        this.eventBus.fireEvent((IEvent)new FieldUpdatedEvent(payload));
    }

    public void onNextStepExecuted() {
        this.eventBus.fireEvent((IEvent)new NextStepExecutedEvent());
    }

    public void onRunToProcessorExecuted() {
        this.eventBus.fireEvent((IEvent)new RunToProcessorExecutedEvent());
    }
}

