/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.controller;

import com.mulesoft.mule.debugger.dto.MuleMessageInfo;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.mule.tooling.ui.contribution.debugger.controller.DebuggerEventTypes;
import org.mule.tooling.ui.contribution.debugger.controller.ObjectFieldDefinitionTreeContentProvider;
import org.mule.tooling.ui.contribution.debugger.controller.TreeNodeLabelProvider;
import org.mule.tooling.ui.contribution.debugger.controller.events.INewMuleMessageArrivedHandler;
import org.mule.tooling.ui.contribution.debugger.view.IObjectFieldDefinitionEditor;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerWidgetsBuilder;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEventHandler;

public abstract class AbstractObjectFieldDefinitionController {
    private IObjectFieldDefinitionEditor editor;
    private final EventBus eventBus;
    private INewMuleMessageArrivedHandler populateDataOnMessageArrival;

    public AbstractObjectFieldDefinitionController(IObjectFieldDefinitionEditor editor, EventBus eventBus) {
        this.setEditor(editor);
        this.eventBus = eventBus;
        this.bind();
    }

    protected void bind() {
        this.getEditor().getPayloadTreeViewer().setContentProvider((IContentProvider)new ObjectFieldDefinitionTreeContentProvider());
        this.getEditor().getPayloadTreeViewer().setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TreeNodeLabelProvider()));
        this.getEditor().getPayloadTreeViewer().getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFDF;
                if ((event.detail & 2) == 0) {
                    return;
                }
                Tree table = (Tree)event.widget;
                int clientWidth = table.getClientArea().width;
                GC gc = event.gc;
                Color oldBackground = gc.getBackground();
                gc.setBackground(ThemeUtils.getCurrentTheme().getDebuggerVariablesTreeSelectionColor());
                gc.setAlpha(196);
                gc.fillRectangle(0, event.y, clientWidth, event.height);
                gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFFD;
            }
        });
        this.getEditor().getPayloadTreeViewer().addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (!selection.isEmpty()) {
                IStructuredSelection treeSelection = (IStructuredSelection)selection;
                TreeNode node = (TreeNode)treeSelection.getFirstElement();
                ObjectFieldDefinition definition = (ObjectFieldDefinition)node.getValue();
                String quotedString = DebuggerWidgetsBuilder.getQuotedString(definition, (Boolean)false);
                if (definition.isError()) {
                    this.getEditor().setSelectionTextErrorValue(quotedString);
                } else {
                    this.getEditor().setSelectionTextValue(quotedString);
                }
            } else {
                this.getEditor().setSelectionTextValue("");
            }
        });
        this.populateDataOnMessageArrival = (muleMessageInfo, exceptionThrown) -> Display.getDefault().asyncExec(() -> {
            this.populateData(muleMessageInfo, exceptionThrown);
            if (exceptionThrown == null) {
                this.getEditor().setSelectionTextValue("");
            }
        });
        this.getEventBus().registerListener(DebuggerEventTypes.MULE_MESSAGE_ARRIVED, (IEventHandler)this.populateDataOnMessageArrival);
    }

    protected abstract void populateData(MuleMessageInfo var1, ObjectFieldDefinition var2);

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEditor(IObjectFieldDefinitionEditor editor) {
        this.editor = editor;
    }

    public IObjectFieldDefinitionEditor getEditor() {
        return this.editor;
    }

    public void dispose() {
        this.getEventBus().unRegisterListener(DebuggerEventTypes.MULE_MESSAGE_ARRIVED, (IEventHandler)this.populateDataOnMessageArrival);
    }
}

