/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.console;

import java.util.concurrent.Callable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.console.IHyperlink;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.ui.contribution.debugger.utils.FlowEditorEntityEditPartPair;
import org.mule.tooling.ui.contribution.debugger.utils.MuleDebuggerUtils;
import org.mule.tooling.utils.SilentRunner;

public class MulePathLink
implements IHyperlink {
    private String path;
    private String projectName;

    public MulePathLink(String projectName, String path) {
        this.projectName = projectName;
        this.path = path;
    }

    public void linkActivated() {
        SilentRunner.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FlowEditorEntityEditPartPair pair = MuleDebuggerUtils.findEditPartAndFlowEditor(MulePathLink.this.projectName, MulePathLink.this.path, true);
                MultiPageMessageFlowEditor multiPageFlowEditor = pair.getEditor();
                EntityEditPart<?> editPart = pair.getEditPart();
                if (multiPageFlowEditor != null) {
                    multiPageFlowEditor.openEditor();
                    if (multiPageFlowEditor.getCurentPageIndex() != multiPageFlowEditor.getFlowEditorIndex()) {
                        multiPageFlowEditor.openFlowEditorPage();
                    }
                    multiPageFlowEditor.getFlowEditor().getViewer().reveal(editPart);
                    EntityEditPart<?> editPartFromPath = MuleDebuggerUtils.findEditPartAndFlowEditor(MulePathLink.this.projectName, MulePathLink.this.path, false).getEditPart();
                    multiPageFlowEditor.getFlowEditor().setSelection((ISelection)new StructuredSelection(editPartFromPath));
                }
                return null;
            }
        }, null);
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }
}

