/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.console;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;
import org.mule.tooling.ui.contribution.debugger.console.MulePathLink;

public class MulePathLineTracker
implements IConsoleLineTracker {
    private static final Pattern PATH_LOCATION_PATTERN = Pattern.compile("([/A-z0-9-_#$%^]+)[ ]*@[ ]*([A-z0-9-_#$%^]+)");
    private IConsole console;

    public void init(IConsole console) {
        this.console = console;
    }

    public void lineAppended(IRegion line) {
        try {
            int lineOffset = line.getOffset();
            int lineLength = line.getLength();
            String text = this.console.getDocument().get(lineOffset, lineLength);
            this.doMatch(PATH_LOCATION_PATTERN, text, lineOffset, lineLength);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void doMatch(Pattern pattern, String text, int lineOffset, int lineLength) {
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String path = null;
            int linkOffset = -1;
            int linkLength = -1;
            path = matcher.group(1);
            linkOffset = lineOffset + matcher.start(1);
            linkLength = matcher.end(1) - matcher.start(1);
            if (path == null) continue;
            String projectName = matcher.group(2);
            MulePathLink link = new MulePathLink(projectName, path);
            this.console.addLink((IHyperlink)link, linkOffset, linkLength);
        }
    }

    public void dispose() {
        this.console = null;
    }
}

